/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerAirCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAirCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiAirCompressor
extends GuiPneumaticContainerBase<ContainerAirCompressor, TileEntityAirCompressor> {
    public GuiAirCompressor(ContainerAirCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AIR_COMPRESSOR;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        super.func_230450_a_(matrixStack, partialTicks, x, y);
        int yOff = ((TileEntityAirCompressor)this.te).getBurnTimeRemainingScaled(12);
        if (((TileEntityAirCompressor)this.te).burnTime >= ((TileEntityAirCompressor)this.te).curFuelUsage) {
            this.func_238474_b_(matrixStack, this.field_147003_i + this.getFuelSlotXOffset(), this.field_147009_r + 38 + 12 - yOff, 176, 12 - yOff, 14, yOff + 2);
        }
    }

    protected int getFuelSlotXOffset() {
        return 80;
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((TileEntityAirCompressor)this.te).airPerTick, 2)).func_240699_a_(TextFormatting.BLACK));
    }

    @Override
    protected void addProblems(List<ITextComponent> textList) {
        super.addProblems(textList);
        if (((TileEntityAirCompressor)this.te).burnTime <= ((TileEntityAirCompressor)this.te).curFuelUsage && !FurnaceTileEntity.func_213991_b((ItemStack)((TileEntityAirCompressor)this.te).getPrimaryInventory().getStackInSlot(0))) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.airCompressor.noFuel", new Object[0]));
        }
        if (((TileEntityAirCompressor)this.te).hasNoConnectedAirHandlers()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.airLeak", new Object[0]));
        }
    }

    @Override
    protected String upgradeCategory() {
        return "air_compressor";
    }
}

