/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public abstract class PressureChamberRecipe
extends PneumaticCraftRecipe {
    protected PressureChamberRecipe(ResourceLocation id) {
        super(id);
    }

    @Deprecated
    public float getCraftingPressure() {
        return 0.0f;
    }

    public float getCraftingPressure(IItemHandler chamberHandler, List<Integer> ingredientSlots) {
        return this.getCraftingPressure();
    }

    public abstract float getCraftingPressureForDisplay();

    public abstract Collection<Integer> findIngredients(@Nonnull IItemHandler var1);

    public abstract List<Ingredient> getInputsForDisplay();

    protected List<ItemStack> getSingleResultsForDisplay() {
        return ImmutableList.of();
    }

    public List<List<ItemStack>> getResultsForDisplay() {
        return (List)this.getSingleResultsForDisplay().stream().map(ImmutableList::of).collect(ImmutableList.toImmutableList());
    }

    protected List<Set<RecipeSlot>> getSyncGroupsForDisplay() {
        return ImmutableList.of();
    }

    public Map<RecipeSlot, List<Integer>> getSyncForDisplay(SlotCycle focusedSlotCycle) {
        RecipeSlot focusedSlot = focusedSlotCycle.getSlot();
        return (Map)this.getSyncGroupsForDisplay().stream().filter(set -> set.contains(focusedSlot)).findAny().map(set -> (ImmutableMap)set.stream().collect(ImmutableMap.toImmutableMap(slot -> slot, slot -> focusedSlotCycle.getCycle()))).orElseGet(ImmutableMap::of);
    }

    public abstract boolean isValidInputItem(ItemStack var1);

    @Nonnull
    public abstract NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler var1, List<Integer> var2, boolean var3);

    public String getTooltipKey(boolean input, int slot) {
        return "";
    }

    public static final class SlotCycle {
        private final RecipeSlot slot;
        private final ImmutableList<Integer> cycle;

        public SlotCycle(RecipeSlot slot, ImmutableList<Integer> cycle) {
            this.slot = slot;
            this.cycle = cycle;
        }

        public RecipeSlot getSlot() {
            return this.slot;
        }

        public ImmutableList<Integer> getCycle() {
            return this.cycle;
        }
    }

    public static final class RecipeSlot {
        private final boolean input;
        private final int index;

        public RecipeSlot(boolean input, int index) {
            this.input = input;
            this.index = index;
        }

        public boolean isInput() {
            return this.input;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipeSlot that = (RecipeSlot)o;
            return this.input == that.input && this.index == that.index;
        }

        public int hashCode() {
            return Objects.hash(this.input, this.index);
        }
    }
}

