/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NoNBTIngredient
extends Ingredient {
    private final ItemStack stack;

    public NoNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack;
    }

    public NoNBTIngredient(IItemProvider item) {
        this(new ItemStack(item));
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() == this.stack.func_77973_b() && !stack.func_77942_o();
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        json.addProperty("item", this.stack.func_77973_b().getRegistryName().toString());
        json.addProperty("count", (Number)this.stack.func_190916_E());
        return json;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<NoNBTIngredient> {
        public static final IIngredientSerializer<NoNBTIngredient> INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:no_nbt");

        public NoNBTIngredient parse(PacketBuffer buffer) {
            return new NoNBTIngredient(buffer.func_150791_c());
        }

        public NoNBTIngredient parse(JsonObject json) {
            return new NoNBTIngredient(ShapedRecipe.func_199798_a((JsonObject)json));
        }

        public void write(PacketBuffer buffer, NoNBTIngredient ingredient) {
            buffer.func_150788_a(ingredient.stack);
        }
    }
}

