/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.fakeplayer;

import com.mojang.authlib.GameProfile;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.fakeplayer.FakeNetHandler;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.Stat;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class APFakePlayer
extends FakePlayer {
    public static final GameProfile PROFILE = new GameProfile(UUID.fromString("6e483f02-30db-4454-b612-3a167614b276"), "[advancedperipherals]");
    private static final Predicate<Entity> collidablePredicate = EntityPredicates.field_180132_d;
    private final WeakReference<Entity> owner;
    private BlockPos digPosition;
    private Block digBlock;
    private float currentDamage = 0.0f;

    public APFakePlayer(ServerWorld world, Entity owner, GameProfile profile) {
        super(world, profile != null && profile.isComplete() ? profile : PROFILE);
        this.field_71135_a = new FakeNetHandler(this);
        if (owner != null) {
            this.func_200203_b(owner.func_200200_C_());
            this.owner = new WeakReference<Entity>(owner);
        } else {
            this.owner = null;
        }
    }

    @Deprecated
    public APFakePlayer(World world) {
        super((ServerWorld)world, PROFILE);
        this.owner = null;
    }

    public void func_71029_a(@NotNull Stat<?> stat) {
        ServerPlayerEntity player;
        MinecraftServer server = this.field_70170_p.func_73046_m();
        if (server != null && this.func_146103_bH() != PROFILE && (player = server.func_184103_al().func_177451_a(this.func_110124_au())) != null) {
            player.func_71029_a(stat);
        }
    }

    public boolean func_213336_c(@NotNull LivingEntity p_213336_1_) {
        return true;
    }

    public void func_175141_a(@NotNull SignTileEntity p_175141_1_) {
    }

    public boolean func_174814_R() {
        return true;
    }

    public void func_184185_a(@Nonnull SoundEvent soundIn, float volume, float pitch) {
    }

    private void setState(Block block, BlockPos pos) {
        if (this.digPosition != null) {
            this.field_71134_c.func_225416_a(this.digPosition, CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, Direction.EAST, 1);
        }
        this.digPosition = pos;
        this.digBlock = block;
        this.currentDamage = 0.0f;
    }

    public float func_213307_e(@NotNull Pose pose) {
        return 0.0f;
    }

    public Pair<Boolean, String> digBlock(Direction direction) {
        ServerWorld world = this.func_71121_q();
        RayTraceResult hit = this.findHit(true, false);
        if (hit.func_216346_c() == RayTraceResult.Type.MISS) {
            return Pair.of(false, "Nothing to break");
        }
        BlockPos pos = new BlockPos(hit.func_216347_e().field_72450_a, hit.func_216347_e().field_72448_b, hit.func_216347_e().field_72449_c);
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack tool = this.field_71071_by.func_70448_g();
        if (tool.func_190926_b()) {
            return Pair.of(false, "Cannot dig without tool");
        }
        if (block != this.digBlock || !pos.equals((Object)this.digPosition)) {
            this.setState(block, pos);
        }
        if (!world.func_175623_d(pos) && !state.func_185904_a().func_76224_d()) {
            if (block == Blocks.field_150357_h || state.func_185887_b((IBlockReader)world, pos) <= -1.0f) {
                return Pair.of(false, "Unbreakable block detected");
            }
            if (tool.getHarvestLevel(ToolType.PICKAXE, (PlayerEntity)this, state) < state.getHarvestLevel()) {
                return Pair.of(false, "Tool are too cheap for this block");
            }
            PlayerInteractionManager manager = this.field_71134_c;
            float breakSpeed = 0.5f * tool.func_150997_a(state) / state.func_185887_b((IBlockReader)this.field_70170_p, pos) - 0.1f;
            for (int i = 0; i < 10; ++i) {
                this.currentDamage += breakSpeed;
                world.func_175715_c(this.func_145782_y(), pos, i);
                if (!(this.currentDamage > 9.0f)) continue;
                world.func_184133_a(null, pos, state.func_215695_r().func_185846_f(), SoundCategory.NEUTRAL, 0.25f, 1.0f);
                manager.func_225416_a(pos, CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, direction.func_176734_d(), 1);
                manager.func_180237_b(pos);
                world.func_175715_c(this.func_145782_y(), pos, -1);
                this.setState(null, null);
                break;
            }
            return Pair.of(true, "block");
        }
        return Pair.of(false, "Nothing to dig here");
    }

    public ActionResultType useOnBlock() {
        return this.use(true, false);
    }

    public ActionResultType useOnEntity() {
        return this.use(false, true);
    }

    public ActionResultType useOnFilteredEntity(Predicate<Entity> filter) {
        return this.use(false, true, filter);
    }

    public ActionResultType useOnSpecificEntity(@NotNull Entity entity, RayTraceResult result) {
        ActionResultType simpleInteraction = this.func_190775_a(entity, Hand.MAIN_HAND);
        if (simpleInteraction == ActionResultType.SUCCESS) {
            return simpleInteraction;
        }
        if (ForgeHooks.onInteractEntityAt((PlayerEntity)this, (Entity)entity, (Vector3d)result.func_216347_e(), (Hand)Hand.MAIN_HAND) != null) {
            return ActionResultType.FAIL;
        }
        return entity.func_184199_a((PlayerEntity)this, result.func_216347_e(), Hand.MAIN_HAND);
    }

    public ActionResultType use(boolean skipEntity, boolean skipBlock) {
        return this.use(skipEntity, skipBlock, null);
    }

    public ActionResultType use(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        RayTraceResult hit = this.findHit(skipEntity, skipBlock, entityFilter);
        if (hit instanceof BlockRayTraceResult) {
            Block block;
            boolean bypass;
            ActionResultType result;
            ItemStack stack = this.func_184614_ca();
            BlockRayTraceResult blockHit = (BlockRayTraceResult)hit;
            BlockPos pos = ((BlockRayTraceResult)hit).func_216350_a();
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)this, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (BlockRayTraceResult)blockHit);
            if (event.isCanceled()) {
                return event.getCancellationResult();
            }
            if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(new ItemUseContext(this.field_70170_p, (PlayerEntity)this, Hand.MAIN_HAND, stack, blockHit))) != ActionResultType.PASS) {
                return result;
            }
            boolean bl = bypass = this.func_184614_ca().doesSneakBypassUse((IWorldReader)this.field_70170_p, pos, (PlayerEntity)this) && this.func_184614_ca().doesSneakBypassUse((IWorldReader)this.field_70170_p, pos, (PlayerEntity)this);
            if (this.func_213283_Z() != Pose.CROUCHING || bypass || event.getUseBlock() == Event.Result.ALLOW) {
                ActionResultType useType = this.field_71134_c.func_219441_a((ServerPlayerEntity)this, this.field_70170_p, stack, Hand.MAIN_HAND, blockHit);
                if (event.getUseBlock() != Event.Result.DENY && useType == ActionResultType.SUCCESS) {
                    return ActionResultType.SUCCESS;
                }
            }
            if (stack.func_190926_b() || this.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return ActionResultType.PASS;
            }
            if (stack.func_77973_b() instanceof BlockItem && ((block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof CommandBlockBlock || block instanceof StructureBlock)) {
                return ActionResultType.FAIL;
            }
            if (event.getUseItem() == Event.Result.DENY) {
                return ActionResultType.PASS;
            }
            ItemStack copyBeforeUse = stack.func_77946_l();
            ActionResultType result2 = stack.func_196084_a(new ItemUseContext(this.field_70170_p, (PlayerEntity)this, Hand.MAIN_HAND, copyBeforeUse, blockHit));
            if (stack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this, (ItemStack)copyBeforeUse, (Hand)Hand.MAIN_HAND);
            }
            return result2;
        }
        if (hit instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityHit = (EntityRayTraceResult)hit;
            return this.useOnSpecificEntity(entityHit.func_216348_a(), (RayTraceResult)entityHit);
        }
        return ActionResultType.FAIL;
    }

    public RayTraceResult findHit(boolean skipEntity, boolean skipBlock) {
        return this.findHit(skipEntity, skipBlock, null);
    }

    @Nonnull
    public RayTraceResult findHit(boolean skipEntity, boolean skipBlock, @Nullable Predicate<Entity> entityFilter) {
        ModifiableAttributeInstance reachAttribute = this.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttribute == null) {
            throw new IllegalArgumentException("How did this happened?");
        }
        double range = reachAttribute.func_111126_e();
        Vector3d origin = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d look = this.func_70040_Z();
        Vector3d target = new Vector3d(origin.field_72450_a + look.field_72450_a * range, origin.field_72448_b + look.field_72448_b * range, origin.field_72449_c + look.field_72449_c * range);
        RayTraceContext traceContext = new RayTraceContext(origin, target, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this);
        Vector3d directionVec = traceContext.func_222253_b().func_178788_d(traceContext.func_222250_a());
        Direction traceDirection = Direction.func_210769_a((double)directionVec.field_72450_a, (double)directionVec.field_72448_b, (double)directionVec.field_72449_c);
        Object blockHit = skipBlock ? BlockRayTraceResult.func_216352_a((Vector3d)traceContext.func_222250_a(), (Direction)traceDirection, (BlockPos)new BlockPos(traceContext.func_222250_a())) : (RayTraceResult)IBlockReader.func_217300_a((RayTraceContext)traceContext, (rayTraceContext, blockPos) -> {
            if (this.field_70170_p.func_175623_d(blockPos)) {
                return null;
            }
            return new BlockRayTraceResult(new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), traceDirection, blockPos, false);
        }, rayTraceContext -> BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.func_222250_a(), (Direction)traceDirection, (BlockPos)new BlockPos(rayTraceContext.func_222250_a())));
        if (skipEntity) {
            return blockHit;
        }
        List entities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72314_b(1.0, 1.0, 1.0), collidablePredicate);
        LivingEntity closestEntity = null;
        Vector3d closestVec = null;
        double closestDistance = range;
        for (Entity entityHit : entities) {
            Vector3d clipVec;
            double distance;
            if (!(entityHit instanceof LivingEntity) || entityFilter != null && !entityFilter.test(entityHit)) continue;
            AxisAlignedBB box = entityHit.func_174813_aQ().func_186662_g((double)entityHit.func_70111_Y() + 0.5);
            Optional clipResult = box.func_216365_b(origin, target);
            if (box.func_72318_a(origin)) {
                if (!(closestDistance >= 0.0)) continue;
                closestEntity = (LivingEntity)entityHit;
                closestVec = clipResult.orElse(origin);
                closestDistance = 0.0;
                continue;
            }
            if (!clipResult.isPresent() || !((distance = origin.func_72438_d(clipVec = (Vector3d)clipResult.get())) < closestDistance) && closestDistance != 0.0) continue;
            if (entityHit == entityHit.func_184208_bv() && !entityHit.canRiderInteract()) {
                if (closestDistance != 0.0) continue;
                closestEntity = (LivingEntity)entityHit;
                closestVec = clipVec;
                continue;
            }
            closestEntity = (LivingEntity)entityHit;
            closestVec = clipVec;
            closestDistance = distance;
        }
        if (closestEntity != null && closestDistance <= range && (blockHit.func_216346_c() == RayTraceResult.Type.MISS || this.func_195048_a(blockHit.func_216347_e()) > closestDistance * closestDistance)) {
            return new EntityRayTraceResult(closestEntity, closestVec);
        }
        return blockHit;
    }
}

