/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.tileentity;

import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.EnergyDetectorPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.APTileEntityBlock;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.TileEntityTypes;
import de.srendi.advancedperipherals.common.util.EnergyStorageProxy;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyDetectorTile
extends PeripheralTileEntity<EnergyDetectorPeripheral>
implements ITickableTileEntity {
    private final EnergyStorage zeroStorage = new EnergyStorage(0, 0, 0);
    public int transferRate = 0;
    public EnergyStorageProxy storageProxy;
    LazyOptional<IEnergyStorage> energyStorageCap;
    Direction energyInDirection;
    Direction energyOutDirection;
    LazyOptional<IEnergyStorage> zeroStorageCap;
    @NotNull
    private Optional<IEnergyStorage> outReceivingStorage;

    public EnergyDetectorTile() {
        super((TileEntityType)TileEntityTypes.ENERGY_DETECTOR.get());
        this.storageProxy = new EnergyStorageProxy(this, (Integer)APConfig.PERIPHERALS_CONFIG.ENERGY_DETECTOR_MAX_FLOW.get());
        this.energyStorageCap = LazyOptional.of(() -> this.storageProxy);
        this.energyInDirection = Direction.NORTH;
        this.energyOutDirection = Direction.SOUTH;
        this.zeroStorageCap = LazyOptional.of(() -> this.zeroStorage);
        this.outReceivingStorage = Optional.empty();
    }

    @Override
    @NotNull
    protected EnergyDetectorPeripheral createPeripheral() {
        return new EnergyDetectorPeripheral(this);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction direction) {
        this.energyInDirection = (Direction)this.func_195044_w().func_177229_b((Property)APTileEntityBlock.FACING);
        this.energyOutDirection = ((Direction)this.func_195044_w().func_177229_b((Property)APTileEntityBlock.FACING)).func_176734_d();
        if (cap == CapabilityEnergy.ENERGY) {
            if (direction == this.energyInDirection) {
                return this.energyStorageCap.cast();
            }
            if (direction == this.energyOutDirection) {
                return this.zeroStorageCap.cast();
            }
        }
        return super.getCapability(cap, direction);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.transferRate = this.storageProxy.getTransferedInThisTick();
            this.storageProxy.resetTransferedInThisTick();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("rateLimit", this.storageProxy.getMaxTransferRate());
        return compound;
    }

    public void deserializeNBT(BlockState state, CompoundNBT nbt) {
        this.storageProxy.setMaxTransferRate(nbt.func_74762_e("rateLimit"));
        super.deserializeNBT(state, nbt);
    }

    @NotNull
    public Optional<IEnergyStorage> getOutputStorage() {
        if (!this.outReceivingStorage.isPresent()) {
            TileEntity teOut = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.energyOutDirection));
            if (teOut == null) {
                return Optional.empty();
            }
            LazyOptional lazyOptionalOutStorage = teOut.getCapability(CapabilityEnergy.ENERGY, this.energyOutDirection.func_176734_d());
            this.outReceivingStorage = lazyOptionalOutStorage.resolve();
            lazyOptionalOutStorage.addListener(l -> {
                this.outReceivingStorage = Optional.empty();
            });
        }
        return this.outReceivingStorage;
    }
}

