/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanismgenerators;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import net.minecraft.tileentity.TileEntity;

public class TurbineIntegration
extends TileEntityIntegrationPeripheral<TileEntityTurbineValve> {
    public TurbineIntegration(TileEntity entity) {
        super(entity);
    }

    public String getType() {
        return "turbine";
    }

    @LuaFunction(mainThread=true)
    public final long getSteam() {
        return this.getTurbine().gasTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getSteamCapacity() {
        return this.getTurbine().gasTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getSteamNeeded() {
        return this.getTurbine().gasTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final long getLastSteamInputRate() {
        return this.getTurbine().lastSteamInput;
    }

    @LuaFunction(mainThread=true)
    public final double getSteamFilledPercentage() {
        return (double)this.getSteam() / (double)this.getSteamCapacity();
    }

    @LuaFunction(mainThread=true)
    public final String getDumpingMode() {
        return this.getTurbine().dumpMode.name();
    }

    @LuaFunction(mainThread=true)
    public final long getProductionRate() {
        FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(this.getBlades(), this.getCoils() * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(energyMultiplier.multiply(this.getTurbine().clientFlow));
    }

    @LuaFunction(mainThread=true)
    public final long getMaxProduction() {
        FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(this.getBlades(), this.getCoils() * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
        double rate = (double)this.getTurbine().lowerVolume * ((double)this.getTurbine().getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
        rate = Math.min(rate, (double)this.getVents() * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(energyMultiplier.multiply(rate));
    }

    @LuaFunction(mainThread=true)
    public final long getFlowRate() {
        return this.getTurbine().clientFlow;
    }

    @LuaFunction(mainThread=true)
    public final long getMaxFlowRate() {
        double rate = (double)this.getTurbine().lowerVolume * ((double)this.getTurbine().getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
        rate = Math.min(rate, (double)this.getVents() * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
        return MathUtils.clampToLong((double)rate);
    }

    @LuaFunction(mainThread=true)
    public final long getMaxWaterOutput() {
        return (long)this.getCondensers() * (long)MekanismGeneratorsConfig.generators.condenserRate.get();
    }

    @LuaFunction(mainThread=true)
    public final int getDispersers() {
        return this.getTurbine().getDispersers();
    }

    @LuaFunction(mainThread=true)
    public final int getVents() {
        return this.getTurbine().vents;
    }

    @LuaFunction(mainThread=true)
    public final int getBlades() {
        return this.getTurbine().blades;
    }

    @LuaFunction(mainThread=true)
    public final int getCoils() {
        return this.getTurbine().coils;
    }

    @LuaFunction(mainThread=true)
    public final int getCondensers() {
        return this.getTurbine().condensers;
    }

    private TurbineMultiblockData getTurbine() {
        return (TurbineMultiblockData)((TileEntityTurbineValve)this.tileEntity).getMultiblock();
    }
}

