/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanismgenerators;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;

public class FusionIntegration
extends TileEntityIntegrationPeripheral<TileEntityFusionReactorLogicAdapter> {
    public FusionIntegration(TileEntity entity) {
        super(entity);
    }

    public String getType() {
        return "fusionReactor";
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getHohlraum() {
        ItemStack stack = this.getReactor().getStackInSlot(0);
        HashMap<String, Object> wrapped = new HashMap<String, Object>(3);
        wrapped.put("name", stack.func_77973_b().getRegistryName().toString());
        wrapped.put("count", stack.func_190916_E());
        wrapped.put("nbt", NBTUtil.toLua((INBT)stack.func_196082_o()));
        wrapped.put("tags", LuaConverter.tagsToList(stack.func_77973_b().getTags()));
        return wrapped;
    }

    @LuaFunction(mainThread=true)
    public final double getPlasmaTemperature() {
        return this.getReactor().getPlasmaTemp();
    }

    @LuaFunction(mainThread=true)
    public final double getCaseTemperature() {
        return this.getReactor().getCaseTemp();
    }

    @LuaFunction(mainThread=true)
    public final int getWater() {
        return this.getReactor().waterTank.getFluidAmount();
    }

    @LuaFunction(mainThread=true)
    public final int getWaterCapacity() {
        return this.getReactor().waterTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final int getWaterNeeded() {
        return this.getReactor().waterTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getWaterFilledPercentage() {
        return (double)this.getWater() / (double)this.getWaterCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getSteam() {
        return this.getReactor().steamTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getSteamCapacity() {
        return this.getReactor().steamTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getSteamNeeded() {
        return this.getReactor().steamTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getSteamFilledPercentage() {
        return (double)this.getSteam() / (double)this.getSteamCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getTritium() {
        return this.getReactor().tritiumTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getTritiumCapacity() {
        return this.getReactor().tritiumTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getTritiumNeeded() {
        return this.getReactor().tritiumTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getTritiumFilledPercentage() {
        return (double)this.getTritium() / (double)this.getTritiumCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getDeuterium() {
        return this.getReactor().deuteriumTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getDeuteriumCapacity() {
        return this.getReactor().deuteriumTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getDeuteriumNeeded() {
        return this.getReactor().deuteriumTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getDeuteriumFilledPercentage() {
        return (double)this.getDeuterium() / (double)this.getDeuteriumCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getDTFuel() {
        return this.getReactor().fuelTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getDTFuelCapacity() {
        return this.getReactor().fuelTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getDTFuelNeeded() {
        return this.getReactor().fuelTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getDTFuelFilledPercentage() {
        return (double)this.getDTFuel() / (double)this.getDTFuelCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getProduction() {
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.getReactor().getPassiveGeneration(false, false));
    }

    @LuaFunction(mainThread=true)
    public final int getInjectionRate() {
        return this.getReactor().getInjectionRate();
    }

    @LuaFunction(mainThread=true)
    public final void setInjectionRate(int rate) {
        this.getReactor().setInjectionRate(rate);
    }

    @LuaFunction(mainThread=true)
    public final long getPassiveGeneration(boolean active) {
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.getReactor().getPassiveGeneration(active, false));
    }

    private FusionReactorMultiblockData getReactor() {
        return (FusionReactorMultiblockData)((TileEntityFusionReactorLogicAdapter)this.tileEntity).getMultiblock();
    }
}

