/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.stal111.forbidden_arcanus.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    public static final RenderType RENDER_TYPE = RenderType.func_228633_a_((String)"forbidden_arcanus:block_render_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PlayerContainer.field_226615_c_, false, false)).func_228723_a_(RenderType.field_228520_l_).func_228719_a_(RenderType.field_228528_t_).func_228724_a_(RenderType.field_228521_m_).func_228726_a_(RenderType.field_228515_g_).func_228728_a_(false));
    private static final ClientWorld world = Minecraft.func_71410_x().field_71441_e;

    public static void setRenderLayer(ModBlocks block, RenderType renderType) {
        RenderTypeLookup.setRenderLayer((Block)block.getBlock(), (RenderType)renderType);
    }

    public static void renderFluid(IFluidTank fluidTank, FluidStack fluidStack, IRenderTypeBuffer buffer, Matrix4f matrix, AxisAlignedBB boundingBox, int color, int combinedLight) {
        Fluid fluid = fluidStack.getFluid();
        IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
        ResourceLocation resourceLocation = fluid.getAttributes().getStillTexture();
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(resourceLocation);
        int light1 = combinedLight & 0xFFFF;
        int light2 = combinedLight >> 16 & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        AxisAlignedBB bounds = RenderUtils.getRenderBounds(fluidTank, boundingBox);
        float x1 = (float)bounds.field_72340_a;
        float x2 = (float)bounds.field_72336_d;
        float y1 = (float)bounds.field_72338_b;
        float y2 = (float)bounds.field_72337_e;
        float z1 = (float)bounds.field_72339_c;
        float z2 = (float)bounds.field_72334_f;
        double bx1 = bounds.field_72340_a * 16.0;
        double bx2 = bounds.field_72336_d * 16.0;
        double by1 = bounds.field_72338_b * 16.0;
        double by2 = bounds.field_72337_e * 16.0;
        double bz1 = bounds.field_72339_c * 16.0;
        double bz2 = bounds.field_72334_f * 16.0;
        for (Direction direction : Direction.values()) {
            float v2;
            float v1;
            float u2;
            float u1;
            if (direction == Direction.DOWN) {
                u1 = texture.func_94214_a(bx1);
                u2 = texture.func_94214_a(bx2);
                v1 = texture.func_94207_b(bz1);
                v2 = texture.func_94207_b(bz2);
                builder.func_227888_a_(matrix, x1, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
            }
            if (direction == Direction.UP) {
                u1 = texture.func_94214_a(bx1);
                u2 = texture.func_94214_a(bx2);
                v1 = texture.func_94207_b(bz1);
                v2 = texture.func_94207_b(bz2);
                builder.func_227888_a_(matrix, x1, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
            }
            if (direction == Direction.NORTH) {
                u1 = texture.func_94214_a(bx1);
                u2 = texture.func_94214_a(bx2);
                v1 = texture.func_94207_b(by1);
                v2 = texture.func_94207_b(by2);
                builder.func_227888_a_(matrix, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_225587_b_(light1, light2).func_181675_d();
            }
            if (direction == Direction.SOUTH) {
                u1 = texture.func_94214_a(bx1);
                u2 = texture.func_94214_a(bx2);
                v1 = texture.func_94207_b(by1);
                v2 = texture.func_94207_b(by2);
                builder.func_227888_a_(matrix, x2, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
            }
            if (direction == Direction.WEST) {
                u1 = texture.func_94214_a(by1);
                u2 = texture.func_94214_a(by2);
                v1 = texture.func_94207_b(bz1);
                v2 = texture.func_94207_b(bz2);
                builder.func_227888_a_(matrix, x1, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_225587_b_(light1, light2).func_181675_d();
                builder.func_227888_a_(matrix, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
            }
            if (direction != Direction.EAST) continue;
            u1 = texture.func_94214_a(by1);
            u2 = texture.func_94214_a(by2);
            v1 = texture.func_94207_b(bz1);
            v2 = texture.func_94207_b(bz2);
            builder.func_227888_a_(matrix, x2, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
            builder.func_227888_a_(matrix, x2, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_225587_b_(light1, light2).func_181675_d();
            builder.func_227888_a_(matrix, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
            builder.func_227888_a_(matrix, x2, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_225587_b_(light1, light2).func_181675_d();
        }
    }

    private static AxisAlignedBB getRenderBounds(IFluidTank tank, AxisAlignedBB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.field_72337_e - tankBounds.field_72338_b;
        double y1 = tankBounds.field_72338_b;
        double y2 = tankBounds.field_72338_b + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getAttributes().isLighterThanAir()) {
            double yOff = tankBounds.field_72337_e - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AxisAlignedBB(tankBounds.field_72340_a, y1, tankBounds.field_72339_c, tankBounds.field_72336_d, y2, tankBounds.field_72334_f);
    }

    public static void addItemParticles(World world, ItemStack stack, BlockPos pos, int count) {
        Random random = world.func_201674_k();
        for (int i = 0; i < count; ++i) {
            Vector3d offset = new Vector3d(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            Vector3d vector = new Vector3d(((double)random.nextFloat() - 0.5) * 0.3, (double)(-random.nextFloat()) * 0.6 - 0.3, 0.6);
            vector = vector.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vector.field_72450_a, vector.field_72448_b, vector.field_72449_c, 1, offset.field_72450_a, offset.field_72448_b + 0.05, offset.field_72449_c, 0.0);
                continue;
            }
            world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vector.field_72450_a, vector.field_72448_b, vector.field_72449_c, offset.field_72450_a, offset.field_72448_b + 0.05, offset.field_72449_c);
        }
    }
}

