/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.network;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateItemInSlotPacket {
    private final BlockPos pos;
    private final ItemStack stack;
    private final int slot;

    public UpdateItemInSlotPacket(BlockPos pos, ItemStack stack, int slot) {
        this.pos = pos;
        this.stack = stack;
        this.slot = slot;
    }

    public static void encode(UpdateItemInSlotPacket packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        buffer.func_150788_a(packet.stack);
        buffer.writeInt(packet.slot);
    }

    public static UpdateItemInSlotPacket decode(PacketBuffer buffer) {
        return new UpdateItemInSlotPacket(buffer.func_179259_c(), buffer.func_150791_c(), buffer.readInt());
    }

    public static void consume(UpdateItemInSlotPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = ForbiddenArcanus.proxy.getClientWorld();
            if (world != null && world.func_175625_s(packet.pos) instanceof IInventory) {
                IInventory tileEntity = (IInventory)Objects.requireNonNull(world.func_175625_s(packet.pos));
                tileEntity.func_70299_a(packet.slot, packet.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

