/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.network;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.util.RenderUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemParticlePacket {
    private final BlockPos pos;
    private final ItemStack stack;

    public ItemParticlePacket(BlockPos pos, ItemStack stack) {
        this.pos = pos;
        this.stack = stack;
    }

    public static void encode(ItemParticlePacket packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        buffer.func_150788_a(packet.stack);
    }

    public static ItemParticlePacket decode(PacketBuffer buffer) {
        return new ItemParticlePacket(buffer.func_179259_c(), buffer.func_150791_c());
    }

    public static void consume(ItemParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = ForbiddenArcanus.proxy.getClientWorld();
            RenderUtils.addItemParticles(Objects.requireNonNull(world), packet.stack, packet.pos, 16);
        });
        ctx.get().setPacketHandled(true);
    }
}

