/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.network;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.aureal.capability.AurealProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class AurealUpdatePacket {
    private final UUID uuid;
    private CompoundNBT tag;

    public AurealUpdatePacket(UUID uuid, CompoundNBT tag) {
        this.uuid = uuid;
        this.tag = tag;
    }

    public AurealUpdatePacket(PlayerEntity player) {
        this.uuid = player.func_110124_au();
        player.getCapability(AurealProvider.CAPABILITY, null).ifPresent(aureal -> {
            this.tag = (CompoundNBT)AurealProvider.CAPABILITY.getStorage().writeNBT(AurealProvider.CAPABILITY, aureal, null);
        });
    }

    public static void encode(AurealUpdatePacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.uuid);
        buffer.func_150786_a(packet.tag);
    }

    public static AurealUpdatePacket decode(PacketBuffer buffer) {
        return new AurealUpdatePacket(buffer.func_179253_g(), buffer.func_150793_b());
    }

    public static void consume(AurealUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = ForbiddenArcanus.proxy.getClientWorld();
            PlayerEntity player = world.func_217371_b(packet.uuid);
            if (player != null) {
                player.getCapability(AurealProvider.CAPABILITY).ifPresent(aureal -> AurealProvider.CAPABILITY.getStorage().readNBT(AurealProvider.CAPABILITY, aureal, null, (INBT)packet.tag));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

