/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.item;

import com.stal111.forbidden_arcanus.config.ItemConfig;
import com.stal111.forbidden_arcanus.init.ModItems;
import com.stal111.forbidden_arcanus.item.EdelwoodBucketItem;
import com.stal111.forbidden_arcanus.item.ICapacityBucket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.valhelsia.valhelsia_core.util.ItemStackUtils;

public class EdelwoodFishBucketItem
extends EdelwoodBucketItem {
    private final EntityType<?> fishType;

    public EdelwoodFishBucketItem(EntityType<?> fishType, Fluid containedFluidIn, Item.Properties builder) {
        super(containedFluidIn, builder);
        this.fishType = fishType;
    }

    @Override
    public void onLiquidPlaced(World world, ItemStack stack, BlockPos pos) {
        if (!world.func_201670_d()) {
            this.placeFish((ServerWorld)world, stack, pos);
        }
        super.onLiquidPlaced(world, stack, pos);
    }

    @Override
    protected ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
        if (!player.field_71075_bZ.field_75098_d) {
            int fullness = ICapacityBucket.getFullness(stack);
            if (fullness - 1 > 0) {
                return ICapacityBucket.setFullness(ItemStackUtils.transferEnchantments((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)ModItems.EDELWOOD_WATER_BUCKET.get())), fullness - 1);
            }
            return ItemStackUtils.transferEnchantments((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)ModItems.EDELWOOD_BUCKET.get()));
        }
        return stack;
    }

    @Override
    protected void playEmptySound(@Nullable PlayerEntity player, IWorld world, BlockPos pos) {
        world.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeFish(ServerWorld world, ItemStack stack, BlockPos pos) {
        Entity entity = this.fishType.func_220331_a(world, stack, null, pos, SpawnReason.BUCKET, true, false);
        if (entity instanceof AbstractFishEntity) {
            ((AbstractFishEntity)entity).func_203706_r(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT compoundnbt;
        if (this.fishType == EntityType.field_204262_at && (compoundnbt = stack.func_77978_p()) != null && compoundnbt.func_150297_b("BucketVariantTag", 3)) {
            int i = compoundnbt.func_74762_e("BucketVariantTag");
            TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            String s = "color.minecraft." + TropicalFishEntity.func_212326_d((int)i);
            String s1 = "color.minecraft." + TropicalFishEntity.func_212323_p((int)i);
            for (int j = 0; j < TropicalFishEntity.field_204227_bz.length; ++j) {
                if (i != TropicalFishEntity.field_204227_bz[j]) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent(TropicalFishEntity.func_212324_b((int)j)).func_240701_a_(atextformatting));
                return;
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(TropicalFishEntity.func_212327_q((int)i)).func_240701_a_(atextformatting));
            TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(s);
            if (!s.equals(s1)) {
                iformattabletextcomponent.func_240702_b_(", ").func_230529_a_((ITextComponent)new TranslationTextComponent(s1));
            }
            iformattabletextcomponent.func_240701_a_(atextformatting);
            tooltip.add((ITextComponent)iformattabletextcomponent);
        }
    }

    @Override
    public int getCapacity() {
        return (Integer)ItemConfig.EDELWOOD_WATER_BUCKET_CAPACITY.get();
    }
}

