/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.item;

import com.stal111.forbidden_arcanus.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.valhelsia.valhelsia_core.util.ItemStackUtils;

public class ArcaneBoneMealItem
extends BoneMealItem {
    public ArcaneBoneMealItem(Item.Properties builder) {
        super(builder);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockPos offsetPos = pos.func_177972_a(context.func_196000_l());
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (state.func_177230_c() == Blocks.field_150458_ak) {
            world.func_175656_a(pos, (BlockState)ModBlocks.MAGICAL_FARMLAND.getBlock().func_176223_P().func_206870_a((Property)BlockStateProperties.field_208133_ah, state.func_177229_b((Property)BlockStateProperties.field_208133_ah)));
            world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)state));
            ItemStackUtils.shrinkStack((PlayerEntity)player, (ItemStack)context.func_195996_i());
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (ArcaneBoneMealItem.applyBoneMeal(context.func_195996_i(), world, pos, player)) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, pos, 0);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        boolean flag = state.func_224755_d((IBlockReader)world, pos, context.func_196000_l());
        if (flag && ArcaneBoneMealItem.func_203173_b((ItemStack)context.func_195996_i(), (World)world, (BlockPos)offsetPos, (Direction)context.func_196000_l())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, offsetPos, 0);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static boolean applyBoneMeal(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (ArcaneBoneMealItem.canGrow(world, pos)) {
            ArcaneBoneMealItem.grow(world, pos);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    private static boolean canGrow(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IGrowable) {
            return ((IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)world, pos, state, world.func_201670_d());
        }
        return false;
    }

    private static void grow(World world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        for (int i = 0; i < 1000; ++i) {
            if (!ArcaneBoneMealItem.canGrow(world, pos) || world.func_201670_d()) {
                return;
            }
            ((IGrowable)world.func_180495_p(pos).func_177230_c()).func_225535_a_((ServerWorld)world, world.field_73012_v, pos, world.func_180495_p(pos));
        }
    }
}

