/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.init.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.stal111.forbidden_arcanus.config.WorldGenConfig;
import com.stal111.forbidden_arcanus.world.structure.NipaStructure;
import com.stal111.forbidden_arcanus.world.structure.config.NipaConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;
import net.valhelsia.valhelsia_core.world.SimpleValhelsiaStructure;

public class ModStructures {
    public static final List<IValhelsiaStructure> MOD_STRUCTURES = new ArrayList<IValhelsiaStructure>();
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"forbidden_arcanus");
    public static final RegistryObject<NipaStructure> NIPA = ModStructures.register(new NipaStructure(NipaConfig.CODEC));

    private static <T extends SimpleValhelsiaStructure<?>> RegistryObject<T> register(T structure) {
        MOD_STRUCTURES.add((IValhelsiaStructure)structure);
        return STRUCTURES.register(structure.getName(), () -> structure);
    }

    public static void setupStructures() {
        for (IValhelsiaStructure iStructure : MOD_STRUCTURES) {
            Structure structure = iStructure.getStructure();
            StructureSeparationSettings separationSettings = iStructure.getSeparationSettings();
            Structure.field_236365_a_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), (Object)structure);
            if (iStructure.transformsSurroundingLand()) {
                Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)structure).build();
            }
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)structure, (Object)separationSettings).build();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                    tempMap.put(structure, separationSettings);
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(structure, separationSettings);
                }
            });
        }
    }

    public static class SeparationSettings {
        public static final StructureSeparationSettings NIPA = new StructureSeparationSettings(((Integer)WorldGenConfig.NIPA_SPACING.get()).intValue(), ((Integer)WorldGenConfig.NIPA_SEPARATION.get()).intValue(), 694349230);
    }
}

