/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.event;

import com.stal111.forbidden_arcanus.common.loot.InfernumPickaxeLootModifier;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class LootTableListener {
    public static void registerGlobalModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        LootTableListener.register("infernum_smelting", new InfernumPickaxeLootModifier.Serializer());
    }

    private static <T extends GlobalLootModifierSerializer<?>> void register(String name, T serializer) {
        serializer.setRegistryName(new ResourceLocation("forbidden_arcanus", name));
        ForgeRegistries.LOOT_MODIFIER_SERIALIZERS.register(serializer);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "end_city_treasure": {
                    event.getTable().addPool(LootTableListener.getInjectPool(file));
                    break;
                }
            }
        }
        switch (name) {
            case "minecraft:entities/enderman": {
                event.getTable().addPool(LootTableListener.getInjectPool("enderman"));
                break;
            }
            case "minecraft:entities/bat": {
                event.getTable().addPool(LootTableListener.getInjectPool("bat"));
                break;
            }
            case "minecraft:entities/squid": {
                event.getTable().addPool(LootTableListener.getInjectPool("squid"));
                break;
            }
            case "minecraft:entities/ender_dragon": {
                event.getTable().addPool(LootTableListener.getInjectPool("ender_dragon"));
                break;
            }
            case "minecraft:chests/simple_dungeon": {
                event.getTable().addPool(LootTableListener.getInjectPool("simple_dungeon"));
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(LootTableListener.getInjectEntry(entryName, 1)).bonusRolls(0.0f, 3.0f).name("forbidden_arcanus_inject").func_216044_b();
    }

    private static LootEntry.Builder getInjectEntry(String name, int weight) {
        ResourceLocation table = new ResourceLocation("forbidden_arcanus", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(weight);
    }
}

