/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.entity.projectile;

import com.stal111.forbidden_arcanus.init.ModEntities;
import com.stal111.forbidden_arcanus.sound.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EnergyBallEntity
extends Entity {
    private LivingEntity shootingEntity;
    private int ticksAlive;
    private int ticksInAir;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;

    public EnergyBallEntity(World worldIn) {
        super((EntityType)ModEntities.ENERGY_BALL.get(), worldIn);
    }

    public EnergyBallEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntities.ENERGY_BALL.get(), worldIn);
        this.shootingEntity = shooter;
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(Vector3d.field_186680_a);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.accelerationX = accelX / d0 * 0.1;
        this.accelerationY = accelY / d0 * 0.1;
        this.accelerationZ = accelZ / d0 * 0.1;
    }

    public EnergyBallEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType)ModEntities.ENERGY_BALL.get(), world);
    }

    public EnergyBallEntity(EntityType<? extends EnergyBallEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.shootingEntity == null || !this.shootingEntity.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))) {
            super.func_70071_h_();
            ++this.ticksInAir;
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, entity -> entity.func_70089_S() && entity != this.shootingEntity);
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onImpact(raytraceresult);
            }
            Vector3d vec3d = this.func_213322_ci();
            this.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + (vec3d.field_72448_b - 0.01), this.func_226281_cx_() + vec3d.field_72449_c);
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - vec3d.field_72450_a * 0.25, this.func_226278_cu_() - vec3d.field_72448_b * 0.25, this.func_226281_cx_() - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                f = 0.8f;
            }
            this.func_213317_d(vec3d.func_72441_c(this.accelerationX, this.accelerationY, this.accelerationZ).func_186678_a((double)f));
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        } else {
            this.func_70106_y();
        }
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    public void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                ServerWorld world = (ServerWorld)entity.field_70170_p;
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.shootingEntity), 5.5f);
                LightningBoltEntity lightningBoltEntity = new LightningBoltEntity(EntityType.field_200728_aG, (World)world);
                lightningBoltEntity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                world.func_217376_c((Entity)lightningBoltEntity);
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.field_70170_p.func_184133_a(null, new BlockPos(result.func_216347_e().field_72450_a, result.func_216347_e().field_72448_b, result.func_216347_e().field_72449_c), ModSounds.dark_bolt_hit, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            this.func_70106_y();
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        Vector3d vec3d = this.func_213322_ci();
        compound.func_218657_a("direction", (INBT)this.func_70087_a(new double[]{vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c}));
        compound.func_218657_a("power", (INBT)this.func_70087_a(new double[]{this.accelerationX, this.accelerationY, this.accelerationZ}));
        compound.func_74768_a("life", this.ticksAlive);
    }

    public void func_70037_a(CompoundNBT compound) {
        ListNBT listnbt;
        if (compound.func_150297_b("power", 9) && (listnbt = compound.func_150295_c("power", 6)).size() == 3) {
            this.accelerationX = listnbt.func_150309_d(0);
            this.accelerationY = listnbt.func_150309_d(1);
            this.accelerationZ = listnbt.func_150309_d(2);
        }
        this.ticksAlive = compound.func_74762_e("life");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).size() == 3) {
            ListNBT listnbt1 = compound.func_150295_c("direction", 6);
            this.func_213293_j(listnbt1.func_150309_d(0), listnbt1.func_150309_d(1), listnbt1.func_150309_d(2));
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vector3d vec3d = source.func_76346_g().func_70040_Z();
            this.func_213317_d(vec3d);
            this.accelerationX = vec3d.field_72450_a * 0.1;
            this.accelerationY = vec3d.field_72448_b * 0.1;
            this.accelerationZ = vec3d.field_72449_c * 0.1;
            if (source.func_76346_g() instanceof LivingEntity) {
                this.shootingEntity = (LivingEntity)source.func_76346_g();
            }
            return true;
        }
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

