/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.tile.forge.ritual;

import com.stal111.forbidden_arcanus.common.tile.forge.HephaestusForgeTileEntity;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.RitualEssences;
import com.stal111.forbidden_arcanus.init.NewModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class Ritual {
    private final ResourceLocation name;
    private final Map<Integer, Ingredient> inputs;
    private final ItemStack hephaestusForgeItem;
    private final ItemStack result;
    private final RitualEssences essences;
    private final ResourceLocation outerTexture;
    private final ResourceLocation innerTexture;
    private final PedestalType pedestalType;
    private final int time;

    public Ritual(ResourceLocation name, Map<Integer, Ingredient> inputs, ItemStack hephaestusForgeItem, ItemStack result, RitualEssences essences, ResourceLocation outerTexture, ResourceLocation innerTexture, int time) {
        this.name = name;
        this.inputs = inputs;
        this.hephaestusForgeItem = hephaestusForgeItem;
        this.result = result;
        this.essences = essences;
        this.outerTexture = outerTexture;
        this.innerTexture = innerTexture;
        this.pedestalType = PedestalType.DARKSTONE_PEDESTAL;
        this.time = time;
    }

    public boolean canStart(List<ItemStack> inputs, HephaestusForgeTileEntity tileEntity) {
        if (!this.getEssences().checkEssences(tileEntity)) {
            return false;
        }
        return this.checkIngredients(inputs, tileEntity);
    }

    public boolean checkIngredients(List<ItemStack> list, HephaestusForgeTileEntity tileEntity) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(list);
        for (Ingredient ingredient : this.getInputs()) {
            boolean foundStack = false;
            for (ItemStack input : ingredients) {
                if (!ingredient.test(input)) continue;
                ingredients.remove(input);
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            return false;
        }
        ItemStack stack = tileEntity.func_70301_a(4);
        if (!ingredients.isEmpty()) {
            return false;
        }
        return this.getHephaestusForgeItem().func_190926_b() ? stack.func_190926_b() : this.getHephaestusForgeItem().equals(stack, false);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public Ingredient getInput(int slot) {
        return this.inputs.get(slot);
    }

    public List<Ingredient> getInputs() {
        return new ArrayList<Ingredient>(this.inputs.values());
    }

    public ItemStack getHephaestusForgeItem() {
        return this.hephaestusForgeItem;
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    public RitualEssences getEssences() {
        return this.essences;
    }

    public ResourceLocation getOuterTexture() {
        return this.outerTexture;
    }

    public ResourceLocation getInnerTexture() {
        return this.innerTexture;
    }

    public PedestalType getPedestalType() {
        return this.pedestalType;
    }

    public int getTime() {
        return this.time;
    }

    public static enum PedestalType {
        DARKSTONE_PEDESTAL((Block)NewModBlocks.DARKSTONE_PEDESTAL.get()),
        ARCANE_DARKSTONE_PEDESTAL((Block)NewModBlocks.ARCANE_DARKSTONE_PEDESTAL.get());

        private final Block block;

        private PedestalType(Block block) {
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

