/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.tile.forge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.MagicCircleModel;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.RitualManager;
import com.stal111.forbidden_arcanus.init.ModParticles;
import com.stal111.forbidden_arcanus.util.CustomRenderType;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class MagicCircle {
    private final RitualManager ritualManager;
    private int rotation;

    public MagicCircle(RitualManager ritualManager) {
        this.ritualManager = ritualManager;
    }

    public void tick() {
        if (this.ritualManager.isRitualActive()) {
            ++this.rotation;
        } else if (this.rotation != 0) {
            this.rotation = 0;
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void render(MatrixStack matrixStack, float partialTicks, IRenderTypeBuffer buffer, int combinedLight, MagicCircleModel model) {
        if (this.ritualManager.isRitualActive()) {
            Ritual ritual = this.ritualManager.getActiveRitual();
            matrixStack.func_227860_a_();
            float ticks = (float)this.rotation + partialTicks;
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            float size = 1.0f + Math.min(ticks, 100.0f) / 100.0f * 7.5f;
            matrixStack.func_227862_a_(size, 1.0f, size);
            float alpha = ticks > (float)ritual.getTime() * 0.9f ? Math.max((float)ritual.getTime() - ticks, 0.0f) / ((float)ritual.getTime() * 0.1f) : 1.0f;
            matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(ticks));
            model.getOuterRing().func_228309_a_(matrixStack, buffer.getBuffer(CustomRenderType.getCutoutFullbright(ritual.getOuterTexture())), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
            matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(-ticks * 2.0f));
            model.getInnerRing().func_228309_a_(matrixStack, buffer.getBuffer(CustomRenderType.getCutoutFullbright(ritual.getInnerTexture())), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
            matrixStack.func_227865_b_();
            if (ticks > (float)ritual.getTime() * 0.9f) {
                World world = Objects.requireNonNull(this.ritualManager.getTileEntity().func_145831_w());
                BlockPos pos = this.ritualManager.getTileEntity().func_174877_v();
                Random rand = world.func_201674_k();
                double posX = (double)pos.func_177958_n() + 0.25 + (double)rand.nextFloat() + (double)rand.nextInt(4);
                double posZ = (double)pos.func_177952_p() + 0.25 + (double)rand.nextFloat() + (double)rand.nextInt(4);
                double ySpeed = ((double)rand.nextFloat() - 0.4) * 0.125;
                world.func_195594_a((IParticleData)ModParticles.AUREAL_MOTE.get(), posX - 2.0, (double)((float)pos.func_177956_o() + 0.1f), posZ - 2.0, 0.0, ySpeed, 0.0);
            }
        }
    }
}

