/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.tile.forge;

import com.stal111.forbidden_arcanus.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.container.HephaestusForgeContainer;
import com.stal111.forbidden_arcanus.common.container.InputType;
import com.stal111.forbidden_arcanus.common.container.input.HephaestusForgeInputs;
import com.stal111.forbidden_arcanus.common.container.input.IHephaestusForgeInput;
import com.stal111.forbidden_arcanus.common.tile.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.tile.forge.MagicCircle;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.EssenceManager;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.RitualManager;
import com.stal111.forbidden_arcanus.init.ModTileEntities;
import com.stal111.forbidden_arcanus.network.NetworkHandler;
import com.stal111.forbidden_arcanus.network.UpdateItemInSlotPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class HephaestusForgeTileEntity
extends LockableTileEntity
implements ITickableTileEntity,
IInventory {
    private HephaestusForgeLevel level = HephaestusForgeLevel.ONE;
    private final NonNullList<ItemStack> inventoryContents = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final IIntArray hephaestusForgeData;
    private final RitualManager ritualManager = new RitualManager(this);
    private final EssenceManager essenceManager = new EssenceManager(this);
    private final MagicCircle magicCircle = new MagicCircle(this.ritualManager);
    private List<LivingEntity> entities = new ArrayList<LivingEntity>();
    private int displayCounter;

    public HephaestusForgeTileEntity() {
        super((TileEntityType)ModTileEntities.HEPHAESTUS_FORGE.get());
        this.hephaestusForgeData = new IIntArray(){

            public int func_221476_a(int index) {
                EssenceManager manager = HephaestusForgeTileEntity.this.getEssenceManager();
                switch (index) {
                    case 0: {
                        return manager.getLevel().getIndex();
                    }
                    case 1: {
                        return manager.getAureal();
                    }
                    case 2: {
                        return manager.getCorruption();
                    }
                    case 3: {
                        return manager.getSouls();
                    }
                    case 4: {
                        return manager.getBlood();
                    }
                    case 5: {
                        return manager.getExperience();
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                EssenceManager manager = HephaestusForgeTileEntity.this.getEssenceManager();
                switch (index) {
                    case 0: {
                        HephaestusForgeTileEntity.this.setLevel(HephaestusForgeLevel.getFromIndex(value));
                        break;
                    }
                    case 1: {
                        manager.setAureal(value);
                        break;
                    }
                    case 2: {
                        manager.setCorruption(value);
                        break;
                    }
                    case 3: {
                        manager.setSouls(value);
                        break;
                    }
                    case 4: {
                        manager.setBlood(value);
                        break;
                    }
                    case 5: {
                        manager.setExperience(value);
                    }
                }
            }

            public int func_221478_a() {
                return 6;
            }
        };
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        for (int i = 5; i <= 8; ++i) {
            ItemStack stack = (ItemStack)this.inventoryContents.get(i);
            if (stack.func_190926_b()) continue;
            InputType inputType = this.getInputTypeFromSlot(i);
            if (inputType == null) {
                return;
            }
            IHephaestusForgeInput input = this.getInput(stack, inputType);
            if (input == null) continue;
            this.fillWith(inputType, stack, input, i);
            this.func_70296_d();
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            ((HephaestusForgeBlock)this.func_195044_w().func_177230_c()).updateState(this.func_195044_w(), this.field_145850_b, this.field_174879_c);
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.entities = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(5.0, 5.0, 5.0));
            this.essenceManager.func_73660_a();
        }
        if (!this.field_145850_b.func_201670_d()) {
            this.ritualManager.tick();
        }
        if (this.field_145850_b.func_201670_d()) {
            this.magicCircle.tick();
        }
        ++this.displayCounter;
    }

    private InputType getInputTypeFromSlot(int slot) {
        switch (slot) {
            case 5: {
                return InputType.AUREAL;
            }
            case 6: {
                return InputType.SOULS;
            }
            case 7: {
                return InputType.BLOOD;
            }
            case 8: {
                return InputType.EXPERIENCE;
            }
        }
        return null;
    }

    @Nullable
    private IHephaestusForgeInput getInput(ItemStack stack, InputType inputType) {
        if (this.isTypeFull(inputType)) {
            return null;
        }
        return HephaestusForgeInputs.getInputs().stream().filter(input -> input.canInput(inputType, stack)).findFirst().orElse(null);
    }

    private boolean isTypeFull(InputType inputType) {
        HephaestusForgeLevel level = this.getLevel();
        EssenceManager manager = this.getEssenceManager();
        switch (inputType) {
            case AUREAL: {
                return manager.getAureal() >= level.getMaxAureal();
            }
            case SOULS: {
                return manager.getSouls() >= level.getMaxSouls();
            }
            case BLOOD: {
                return manager.getBlood() >= level.getMaxBlood();
            }
            case EXPERIENCE: {
                return manager.getExperience() >= level.getMaxExperience();
            }
        }
        return true;
    }

    public HephaestusForgeLevel getLevel() {
        return this.level;
    }

    public void setLevel(HephaestusForgeLevel level) {
        this.level = level;
    }

    public IIntArray getHephaestusForgeData() {
        return this.hephaestusForgeData;
    }

    public EssenceManager getEssenceManager() {
        return this.essenceManager;
    }

    public MagicCircle getMagicCircle() {
        return this.magicCircle;
    }

    public List<LivingEntity> getEntities() {
        return this.entities;
    }

    public void fillWith(InputType inputType, ItemStack stack, IHephaestusForgeInput input, int slot) {
        int value = input.getInputValue(inputType, stack, Objects.requireNonNull(this.func_145831_w()).func_201674_k());
        EssenceManager manager = this.getEssenceManager();
        switch (inputType) {
            case AUREAL: {
                manager.increaseAureal(value);
                break;
            }
            case SOULS: {
                manager.increaseSouls(value);
                break;
            }
            case BLOOD: {
                manager.increaseBlood(value);
                break;
            }
            case EXPERIENCE: {
                manager.increaseExperience(value);
            }
        }
        input.finishInput(inputType, stack, this, slot, value);
    }

    public RitualManager getRitualManager() {
        return this.ritualManager;
    }

    public int getDisplayCounter() {
        return this.displayCounter;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("Level", this.getLevel().getName());
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventoryContents);
        compound.func_218657_a("Ritual", (INBT)this.getRitualManager().write(new CompoundNBT()));
        compound.func_218657_a("Essences", (INBT)this.getEssenceManager().write(new CompoundNBT()));
        return compound;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.setLevel(HephaestusForgeLevel.getFromName(compound.func_74779_i("Level")));
        this.inventoryContents.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventoryContents);
        this.getRitualManager().read(compound.func_74775_l("Ritual"));
        this.getEssenceManager().read(compound.func_74775_l("Essences"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager networkManager, SUpdateTileEntityPacket packet) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(packet.func_179823_a()), packet.func_148857_g());
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 1.0, 0.0);
        if (this.getRitualManager().isRitualActive()) {
            boundingBox = boundingBox.func_72314_b(2.5, 0.0, 2.5);
        }
        return boundingBox;
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.forbidden_arcanus.hephaestus_forge");
    }

    @Nonnull
    protected Container func_213906_a(int id, @Nonnull PlayerInventory player) {
        return new HephaestusForgeContainer(id, player, this);
    }

    public int func_70302_i_() {
        return this.inventoryContents.size();
    }

    public boolean func_191420_l() {
        return this.inventoryContents.stream().allMatch(ItemStack::func_190926_b);
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.inventoryContents, (int)index, (int)count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventoryContents, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 4 && this.func_145831_w() != null && !this.func_145831_w().func_201670_d()) {
            BlockPos pos = this.getTileEntity().func_174877_v();
            NetworkHandler.sentToTrackingChunk(this.func_145831_w().func_175726_f(pos), new UpdateItemInSlotPacket(pos, stack, 4));
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.func_145831_w() == null || this.func_145831_w().func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }
}

