/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.RitualEssences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualLoader
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, Ritual> RITUALS = new HashMap<ResourceLocation, Ritual>();

    public RitualLoader() {
        super(GSON, "hephaestus_forge/rituals");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull IResourceManager resourceManager, @Nonnull IProfiler profiler) {
        RITUALS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (resourceLocation.func_110623_a().startsWith("_")) continue;
            try {
                RITUALS.put(resourceLocation, RitualLoader.deserializeRitual(resourceLocation, entry.getValue().getAsJsonObject()));
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                ForbiddenArcanus.LOGGER.error("Parsing error loading hephaestus forge input {}", (Object)resourceLocation, (Object)jsonParseException);
            }
        }
    }

    public static Ritual getRitual(ResourceLocation resourceLocation) {
        return RITUALS.get(resourceLocation);
    }

    public static List<Ritual> getRituals() {
        ArrayList<Ritual> rituals = new ArrayList<Ritual>();
        for (Map.Entry<ResourceLocation, Ritual> entry : RITUALS.entrySet()) {
            rituals.add(entry.getValue());
        }
        return rituals;
    }

    private static Ritual deserializeRitual(ResourceLocation name, JsonObject jsonObject) {
        ItemStack hephaestusForgeInput = ItemStack.field_190927_a;
        if (jsonObject.has("hephaestus_forge_item")) {
            hephaestusForgeInput = new ItemStack((IItemProvider)RitualLoader.deserializeItem(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"hephaestus_forge_item"))));
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"result"), (boolean)true);
        return new Ritual(name, RitualLoader.deserializeInputs(jsonObject), hephaestusForgeInput, result, RitualLoader.deserializeEssences(jsonObject), new ResourceLocation("forbidden_arcanus", "textures/effect/magic_circle/absolute.png"), new ResourceLocation("forbidden_arcanus", "textures/effect/magic_circle/inner_protection.png"), 1200);
    }

    private static Map<Integer, Ingredient> deserializeInputs(JsonObject jsonObject) {
        HashMap<Integer, Ingredient> inputs = new HashMap<Integer, Ingredient>();
        JsonArray jsonArray = jsonObject.getAsJsonArray("inputs");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject input = jsonArray.get(i).getAsJsonObject();
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)input, (boolean)true);
            int slot = input.get("slot").getAsInt();
            if (inputs.containsKey(slot)) {
                throw new IllegalStateException("Slot " + slot + " was already assigned.");
            }
            inputs.put(slot, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
        }
        return inputs;
    }

    private static Item deserializeItem(ResourceLocation name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
        if (item == null) {
            ForbiddenArcanus.LOGGER.error("Item " + name + " does not exist.");
            throw new IllegalArgumentException();
        }
        return item;
    }

    private static RitualEssences deserializeEssences(JsonObject jsonObject) {
        JsonObject essences = jsonObject.get("essences").getAsJsonObject();
        int aureal = JSONUtils.func_151208_a((JsonObject)essences, (String)"aureal", (int)0);
        int corruption = JSONUtils.func_151208_a((JsonObject)essences, (String)"corruption", (int)0);
        int souls = JSONUtils.func_151208_a((JsonObject)essences, (String)"souls", (int)0);
        int blood = JSONUtils.func_151208_a((JsonObject)essences, (String)"blood", (int)0);
        int experience = JSONUtils.func_151208_a((JsonObject)essences, (String)"experience", (int)0);
        return new RitualEssences(aureal, corruption, souls, blood, experience);
    }
}

