/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.container.InputType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class HephaestusForgeInputLoader
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<InputType, Map<Item, InputData>> INPUTS = Maps.newHashMap();

    public HephaestusForgeInputLoader() {
        super(GSON, "hephaestus_forge/inputs");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull IResourceManager resourceManager, @Nonnull IProfiler profiler) {
        INPUTS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (resourceLocation.func_110623_a().startsWith("_")) continue;
            try {
                InputType type = InputType.valueOf(JSONUtils.func_151200_h((JsonObject)entry.getValue().getAsJsonObject(), (String)"type").toUpperCase(Locale.ROOT));
                InputData data = HephaestusForgeInputLoader.deserializeInput(resourceLocation, entry.getValue().getAsJsonObject());
                INPUTS.computeIfAbsent(type, inputType -> new HashMap());
                INPUTS.get((Object)type).put(data.getStack().func_77973_b(), data);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                ForbiddenArcanus.LOGGER.error("Parsing error loading hephaestus forge input {}", (Object)resourceLocation, (Object)jsonParseException);
            }
        }
    }

    private static Map<InputType, Map<Item, InputData>> getInputs() {
        return INPUTS;
    }

    private static InputData deserializeInput(ResourceLocation input, JsonObject jsonObject) {
        ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"item"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            ForbiddenArcanus.LOGGER.error("Item " + resourceLocation + " does not exist.");
            throw new IllegalArgumentException();
        }
        int value = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"value");
        return new InputData(new ItemStack((IItemProvider)item), value);
    }

    public static boolean isValidInput(InputType inputType, ItemStack stack) {
        return HephaestusForgeInputLoader.getInputs().containsKey((Object)inputType) && HephaestusForgeInputLoader.getInputs().get((Object)inputType).containsKey(stack.func_77973_b());
    }

    public static InputData getInputData(InputType inputType, ItemStack stack) {
        return HephaestusForgeInputLoader.getInputs().get((Object)inputType).get(stack.func_77973_b());
    }

    public static class InputData {
        private final ItemStack stack;
        private final int value;

        public InputData(ItemStack stack, int value) {
            this.stack = stack;
            this.value = value;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getValue() {
            return this.value;
        }
    }
}

