/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.stal111.forbidden_arcanus.block.properties.ConnectedBlockType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.valhelsia.valhelsia_core.helper.VoxelShapeHelper;

public class PillarBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<ConnectedBlockType> TYPE = EnumProperty.func_177709_a((String)"type", ConnectedBlockType.class);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape[] SHAPE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)};

    private VoxelShape getShapeForState(BlockState state) {
        List<VoxelShape> list = new ArrayList<VoxelShape>();
        list.add(SHAPE[2]);
        switch ((ConnectedBlockType)((Object)state.func_177229_b(TYPE))) {
            case TOP: {
                list.addAll(Arrays.asList(SHAPE[0], SHAPE[1]));
                break;
            }
            case BOTTOM: {
                list.addAll(Arrays.asList(SHAPE[3], SHAPE[4]));
                break;
            }
            case SINGLE: {
                list = Arrays.asList(SHAPE);
            }
        }
        return VoxelShapeHelper.rotateShapeAxis((VoxelShape)VoxelShapeHelper.combineAll(list), (Direction.Axis)((Direction.Axis)state.func_177229_b(AXIS)));
    }

    public PillarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.Y)).func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.SINGLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.getShapeForState(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.SINGLE))).func_206870_a(AXIS, (Comparable)context.func_196000_l().func_176740_k())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return (BlockState)super.func_196271_a(state, facing, facingState, world, currentPos, facingPos).func_206870_a(TYPE, (Comparable)((Object)this.tryConnect(state, world, currentPos)));
    }

    public ConnectedBlockType tryConnect(BlockState state, IWorld world, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS);
        BlockState stateDown = world.func_180495_p(pos.func_177972_a(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis)));
        BlockState stateUp = world.func_180495_p(pos.func_177972_a(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)));
        boolean axisUpEqual = stateUp.func_177230_c() instanceof PillarBlock && stateUp.func_177229_b(AXIS) == axis;
        boolean axisDownEqual = stateDown.func_177230_c() instanceof PillarBlock && stateDown.func_177229_b(AXIS) == axis;
        return ConnectedBlockType.getTypeForConnections(axisUpEqual, axisDownEqual, axis);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, AXIS, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

