/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.stal111.forbidden_arcanus.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.block.tileentity.NipaTileEntity;
import com.stal111.forbidden_arcanus.init.ModParticles;
import com.stal111.forbidden_arcanus.init.NewModItems;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class NipaBlock
extends BushBlock {
    public static final BooleanProperty SPECK = ModBlockStateProperties.SPECK;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public NipaBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)SPECK, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new NipaTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        NipaTileEntity tileEntity;
        if (((Boolean)state.func_177229_b((Property)SPECK)).booleanValue() && (tileEntity = (NipaTileEntity)world.func_175625_s(pos)) != null) {
            this.harvestSpeck(state, world, pos, tileEntity);
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        NipaTileEntity tileEntity;
        if (!state.func_203425_a(newState.func_177230_c()) && ((Boolean)state.func_177229_b((Property)SPECK)).booleanValue() && (tileEntity = (NipaTileEntity)world.func_175625_s(pos)) != null) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + tileEntity.getSpeckHeight(), (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)NewModItems.ARCANE_CRYSTAL_DUST_SPECK.get())));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        NipaTileEntity tileEntity = (NipaTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            int power = world.func_175687_A(pos);
            if (((Boolean)state.func_177229_b((Property)SPECK)).booleanValue() && tileEntity.getCachedPower() != power && power != 0) {
                this.harvestSpeck(state, world, pos, tileEntity);
            }
            tileEntity.setCachedPower(power);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_71071_by.func_70431_c(new ItemStack((IItemProvider)NewModItems.LENS_OF_VERITATIS.get()))) {
            double j = 0.4 * (double)rand.nextFloat();
            double k = 0.4 * (double)rand.nextFloat();
            double posX = (double)pos.func_177958_n() + 0.5 + (rand.nextBoolean() ? j : -j);
            double posY = (double)pos.func_177956_o() + 0.1 + (double)rand.nextFloat() / 2.5;
            double posZ = (double)pos.func_177952_p() + 0.5 + (rand.nextBoolean() ? k : -k);
            double ySpeed = ((double)rand.nextFloat() - 0.4) * 0.1;
            world.func_195594_a((IParticleData)ModParticles.AUREAL_MOTE.get(), posX, posY, posZ, 0.0, ySpeed, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SPECK});
    }

    private void harvestSpeck(BlockState state, World world, BlockPos pos, NipaTileEntity tileEntity) {
        world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + tileEntity.getSpeckHeight(), (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)NewModItems.ARCANE_CRYSTAL_DUST_SPECK.get())));
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SPECK, (Comparable)Boolean.valueOf(false)));
        tileEntity.setSpeckHeight(10);
    }
}

