/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.stal111.forbidden_arcanus.block.CutoutBlock;
import com.stal111.forbidden_arcanus.block.HangingCandelabraBlock;
import com.stal111.forbidden_arcanus.block.properties.ConnectedBlockType;
import com.stal111.forbidden_arcanus.init.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.valhelsia.valhelsia_core.util.ItemStackUtils;

public class ChainBlock
extends CutoutBlock
implements IWaterLoggable {
    public static final EnumProperty<ConnectedBlockType> TYPE = EnumProperty.func_177709_a((String)"type", ConnectedBlockType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);

    public ChainBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.SINGLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND && ChainBlock.getChainBlocks().contains(Block.func_149634_a((Item)stack.func_77973_b())) && this.pullDown(stack.func_77973_b(), world, pos)) {
            ItemStackUtils.shrinkStack((PlayerEntity)player, (ItemStack)stack);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return !this.func_196260_a(state, (IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState stateUp = world.func_180495_p(pos.func_177984_a());
        if (state.func_177229_b(TYPE) == ConnectedBlockType.TOP || state.func_177229_b(TYPE) == ConnectedBlockType.SINGLE) {
            return ChainBlock.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177984_a(), (Direction)Direction.DOWN);
        }
        return stateUp.func_177230_c() instanceof ChainBlock;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean inWater = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)this.tryConnect(Block.func_149634_a((Item)context.func_195996_i().func_77973_b()).func_176223_P(), context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(inWater));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        world.func_180501_a(pos, this.tryConnect(state, world, pos), 2);
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    public static List<Block> getChainBlocks() {
        return new ArrayList<Block>(Arrays.asList(ModBlocks.IRON_CHAIN.getBlock(), ModBlocks.ARCANE_GOLDEN_CHAIN.getBlock()));
    }

    public boolean pullDown(Item item, World world, BlockPos pos) {
        BlockState state;
        boolean endChain = false;
        boolean wasAirAtEnd = false;
        while (true) {
            if (!World.func_175701_a((BlockPos)(pos = pos.func_177977_b()))) {
                return false;
            }
            state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (ChainBlock.getChainBlocks().contains(block)) continue;
            if (endChain) break;
            endChain = true;
            wasAirAtEnd = world.func_175623_d(pos);
        }
        boolean can = wasAirAtEnd || world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() instanceof LanternBlock || world.func_180495_p(pos).func_177230_c() instanceof HangingCandelabraBlock || state.func_185904_a().func_76222_j();
        if (can) {
            BlockPos chainPos = pos.func_177984_a();
            this.moveBlock(world, chainPos, pos);
            BlockState chainPosState = world.func_180495_p(chainPos);
            if (world.func_175623_d(chainPos) || chainPosState.func_185904_a().func_76222_j()) {
                world.func_175656_a(chainPos, this.tryConnect(Block.func_149634_a((Item)item).func_176223_P(), world, chainPos));
                world.func_184148_a(null, (double)chainPos.func_177958_n(), (double)chainPos.func_177956_o(), (double)chainPos.func_177952_p(), SoundEvents.field_232695_bC_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private void moveBlock(World world, BlockPos srcPos, BlockPos dstPos) {
        BlockState state = world.func_180495_p(srcPos);
        Block block = state.func_177230_c();
        if (!(state.func_185887_b((IBlockReader)world, srcPos) != -1.0f && state.func_196955_c((IWorldReader)world, dstPos) && !block.isAir(state, (IBlockReader)world, srcPos) && state.func_185905_o() == PushReaction.NORMAL && block != Blocks.field_150343_Z || world.func_180495_p(srcPos).func_177230_c() instanceof LanternBlock || world.func_180495_p(srcPos).func_177230_c() instanceof HangingCandelabraBlock)) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(srcPos);
        if (tileEntity != null) {
            tileEntity.func_145843_s();
        }
        world.func_175656_a(srcPos, Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(dstPos, state);
        if (tileEntity != null) {
            tileEntity.func_174878_a(dstPos);
            TileEntity target = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)tileEntity.func_189515_b(new CompoundNBT()));
            if (target != null) {
                world.func_175690_a(dstPos, target);
                target.func_145836_u();
            }
        }
        world.func_195593_d(dstPos, state.func_177230_c());
    }

    private BlockState tryConnect(BlockState state, World world, BlockPos pos) {
        BlockState stateUp = world.func_180495_p(pos.func_177984_a());
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        boolean flagUp = stateUp.func_177230_c() instanceof ChainBlock;
        boolean flagDown = stateDown.func_177230_c() instanceof ChainBlock;
        if (flagUp && !flagDown && !(stateDown.func_177230_c() instanceof LanternBlock) && !(stateDown.func_177230_c() instanceof HangingCandelabraBlock)) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.BOTTOM));
        }
        if (!flagUp && (flagDown || stateDown.func_177230_c() instanceof LanternBlock || stateDown.func_177230_c() instanceof HangingCandelabraBlock)) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.TOP));
        }
        if (flagUp || stateDown.func_177230_c() instanceof LanternBlock || stateDown.func_177230_c() instanceof HangingCandelabraBlock) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.CENTER));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.SINGLE));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

