/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.aureal.capability;

import com.stal111.forbidden_arcanus.aureal.capability.IAureal;
import com.stal111.forbidden_arcanus.aureal.consequence.Consequences;
import com.stal111.forbidden_arcanus.aureal.consequence.IConsequence;
import com.stal111.forbidden_arcanus.util.ISavedData;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class AurealStorage
implements Capability.IStorage<IAureal> {
    @Nullable
    public INBT writeNBT(Capability<IAureal> capability, IAureal instance, Direction side) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("corruption", instance.getCorruption());
        compound.func_74768_a("corruptionTimer", instance.getCorruptionTimer());
        compound.func_74768_a("aureal", instance.getAureal());
        if (!instance.getActiveConsequences().isEmpty()) {
            ListNBT consequences = new ListNBT();
            for (IConsequence consequence : instance.getActiveConsequences()) {
                if (!(consequence instanceof ISavedData)) continue;
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("type", consequence.getName().toString());
                consequences.add((Object)((ISavedData)((Object)consequence)).write(nbt));
            }
            compound.func_218657_a("activeConsequences", (INBT)consequences);
        }
        return compound;
    }

    public void readNBT(Capability<IAureal> capability, IAureal instance, Direction side, INBT nbt) {
        CompoundNBT compound = (CompoundNBT)nbt;
        instance.setCorruption(compound.func_74762_e("corruption"));
        instance.setCorruptionTimer(compound.func_74762_e("corruptionTimer"));
        instance.setAureal(compound.func_74762_e("aureal"));
        if (compound.func_74764_b("activeConsequences")) {
            ListNBT consequences = compound.func_150295_c("activeConsequences", 10);
            for (INBT inbt : consequences) {
                if (!(inbt instanceof CompoundNBT)) continue;
                CompoundNBT compoundNBT = (CompoundNBT)inbt;
                ResourceLocation name = new ResourceLocation(compoundNBT.func_74779_i("type"));
                IConsequence consequence = Objects.requireNonNull(Consequences.getByName(name)).createConsequence();
                if (consequence instanceof ISavedData) {
                    ((ISavedData)((Object)consequence)).read(compoundNBT);
                }
                instance.addActiveConsequence(consequence);
            }
        }
    }
}

