/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class TagUtil {
    public static ITag.INamedTag<Block> createBlockTag(String modid, String name) {
        return TagUtil.createBlockTag(new ResourceLocation(modid, name));
    }

    public static ITag.INamedTag<Block> createBlockTag(ResourceLocation location) {
        Optional<ITag.INamedTag> optional = BlockTags.func_242174_b().stream().filter(tag -> tag.func_230234_a_().equals((Object)location)).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        return BlockTags.func_199894_a((String)location.toString());
    }

    public static ITag.INamedTag<Item> createItemTag(String modid, String name) {
        return TagUtil.createItemTag(new ResourceLocation(modid, name));
    }

    public static ITag.INamedTag<Item> createItemTag(ResourceLocation location) {
        Optional<ITag.INamedTag> optional = ItemTags.func_242177_b().stream().filter(tag -> tag.func_230234_a_().equals((Object)location)).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        return ItemTags.func_199901_a((String)location.toString());
    }

    public static ITag.INamedTag<Fluid> createFluidTag(String modid, String name) {
        return TagUtil.createFluidTag(new ResourceLocation(modid, name));
    }

    public static ITag.INamedTag<Fluid> createFluidTag(ResourceLocation location) {
        Optional<ITag.INamedTag> optional = FluidTags.func_241280_c_().stream().filter(tag -> tag.func_230234_a_().equals((Object)location)).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        return FluidTags.func_206956_a((String)location.toString());
    }

    public static ITag.INamedTag<EntityType<?>> createEntityTypeTag(String modid, String name) {
        return TagUtil.createEntityTypeTag(new ResourceLocation(modid, name));
    }

    public static ITag.INamedTag<EntityType<?>> createEntityTypeTag(ResourceLocation location) {
        Optional<ITag.INamedTag> optional = EntityTypeTags.func_242175_b().stream().filter(tag -> tag.func_230234_a_().equals((Object)location)).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        return EntityTypeTags.func_232896_a_((String)location.toString());
    }

    public static ITag.INamedTag<Block> fromItemTag(ITag.INamedTag<Item> block) {
        return TagUtil.createBlockTag(block.func_230234_a_());
    }

    public static ITag.INamedTag<Item> fromBlockTag(ITag.INamedTag<Block> block) {
        return TagUtil.createItemTag(block.func_230234_a_());
    }

    public static Ingredient getSerializableIngredientOfTag(ITag<Item> tag) {
        return Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(tag){

            public Collection<ItemStack> func_199799_a() {
                return Arrays.asList(new ItemStack((IItemProvider)Items.field_185153_aK));
            }
        }));
    }
}

