/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.container.FluidContainer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class FluidSetAllContainerMessage {
    private final int id;
    private final List<FluidStack> stacks;

    public FluidSetAllContainerMessage(int id, List<FluidStack> stacks) {
        this.id = id;
        this.stacks = stacks;
    }

    public static void encode(FluidSetAllContainerMessage message, PacketBuffer sendBuffer) {
        sendBuffer.writeByte(message.id);
        sendBuffer.writeShort(message.stacks.size());
        for (FluidStack stack : message.stacks) {
            sendBuffer.writeFluidStack(stack);
        }
    }

    public static FluidSetAllContainerMessage decode(PacketBuffer sendBuffer) {
        byte id = sendBuffer.readByte();
        int size = sendBuffer.readShort();
        NonNullList stacks = NonNullList.func_191197_a((int)size, (Object)FluidStack.EMPTY);
        for (int index = 0; index < size; ++index) {
            stacks.set(index, sendBuffer.readFluidStack());
        }
        return new FluidSetAllContainerMessage(id, (List<FluidStack>)stacks);
    }

    public static class Handler {
        public static void handle(FluidSetAllContainerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> Handler.getFluidContainer(Minecraft.func_71410_x().field_71439_g.field_71070_bA, message.id).ifPresent(container -> container.setAllFluidSlots(message.stacks)));
            context.setPacketHandled(true);
        }

        private static final Optional<FluidContainer> getFluidContainer(Container container, int id) {
            if (container instanceof FluidContainer && container.field_75152_c == id) {
                return Optional.of((FluidContainer)container);
            }
            return Optional.empty();
        }
    }
}

