/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.gui.renderer.ScalingTextRenderer;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;

public class ScrollingTextRenderer
extends ScalingTextRenderer {
    protected int width = 100;
    protected float stepSize = 1.0f;
    protected int speedTime = 20;
    protected int waitTime = 4000;
    protected float moveDifference = 0.0f;
    protected long lastTime = 0L;
    protected State state = State.WAITING;

    public ScrollingTextRenderer(FontRenderer fontRenderer, Supplier<String> textSupplier, float x, float y) {
        super(fontRenderer, textSupplier, x, y);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public int getSpeedTime() {
        return this.speedTime;
    }

    public void setSpeedTime(int speedtime) {
        this.speedTime = speedtime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waittime) {
        this.waitTime = waittime;
    }

    public void copyState(ScrollingTextRenderer renderer) {
        this.setText((String)this.textSupplier.get());
        this.state = renderer.state;
        this.moveDifference = renderer.moveDifference;
        this.lastTime = renderer.lastTime;
    }

    @Override
    protected void updatedText() {
        this.state = State.WAITING;
        this.moveDifference = 0.0f;
        this.lastTime = 0L;
        super.updatedText();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        MainWindow window = minecraft.func_228018_at_();
        RenderUtil.Matrix4fExtended matrix = new RenderUtil.Matrix4fExtended(matrixStack.func_227866_c_().func_227870_a_());
        double scaleFactor = window.func_198100_s();
        Vector4f vectorXY = new Vector4f(this.x, this.y, 0.0f, 1.0f);
        vectorXY.func_229372_a_((Matrix4f)matrix);
        float f = (float)this.width * matrix.getM00();
        this.fontRenderer.getClass();
        Vector4f vectorWH = new Vector4f(f, (float)(9 + 1) * this.scale * matrix.getM11(), 0.0f, 1.0f);
        int nativeX = MathHelper.func_76143_f((double)((double)vectorXY.func_195910_a() * scaleFactor));
        int nativeY = MathHelper.func_76143_f((double)((double)vectorXY.func_195913_b() * scaleFactor));
        int nativeWidth = MathHelper.func_76143_f((double)((double)vectorWH.func_195910_a() * scaleFactor));
        int nativeHeight = MathHelper.func_76143_f((double)((double)vectorWH.func_195913_b() * scaleFactor));
        RenderUtil.enableScissor(nativeX, window.func_198083_n() - (nativeY + nativeHeight), nativeWidth, nativeHeight);
        this.setText((String)this.textSupplier.get());
        this.renderFont(matrixStack, this.fontRenderer, this.getMovingX(this.x), this.y + 2.0f * this.scale);
        RenderUtil.disableScissor();
    }

    protected float getMovingX(float x) {
        float textWidth = this.getTextWidth();
        if ((float)this.width < textWidth) {
            float maxMove = (float)this.width - textWidth;
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            if (this.state == State.WAITING) {
                if (this.hasWaitTimePassed()) {
                    this.state = this.moveDifference >= 0.0f ? State.LEFT : State.RIGHT;
                    this.lastTime = 0L;
                }
            } else if (this.hasSpeedTimePassed()) {
                if (this.state == State.LEFT ? this.moveDifference >= maxMove : this.moveDifference <= 0.0f) {
                    this.moveDifference += this.state == State.LEFT ? -this.stepSize : this.stepSize;
                } else {
                    this.state = State.WAITING;
                }
                this.lastTime = 0L;
            }
            return x + this.moveDifference;
        }
        return x;
    }

    protected boolean hasWaitTimePassed() {
        return System.currentTimeMillis() - (long)this.waitTime >= this.lastTime;
    }

    protected boolean hasSpeedTimePassed() {
        return System.currentTimeMillis() - (long)this.speedTime >= this.lastTime;
    }

    private static enum State {
        WAITING,
        LEFT,
        RIGHT;

    }
}

