/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.util.RGBA;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IRenderable;

public class ScalingTextRenderer
implements IRenderable {
    protected static final Consumer<ScalingTextRenderer> EMPTY_TEXT_CHANGED = renderer -> {};
    protected final FontRenderer fontRenderer;
    protected Supplier<String> textSupplier;
    protected float x;
    protected float y;
    private String text;
    private int textWidth;
    protected RGBA color;
    protected boolean shadow;
    protected float scale;
    private float positionFactor;
    protected Consumer<ScalingTextRenderer> textChanged;

    public ScalingTextRenderer(FontRenderer fontRenderer, Supplier<String> textSupplier, float x, float y) {
        this.fontRenderer = fontRenderer;
        this.textSupplier = textSupplier;
        this.x = x;
        this.y = y;
        this.textWidth = -1;
        this.color = RGBA.WHITE;
        this.scale = 1.0f;
        this.positionFactor = 1.0f;
        this.textChanged = EMPTY_TEXT_CHANGED;
    }

    public void setTextSupplier(Supplier<String> textSupplier) {
        Objects.requireNonNull(textSupplier);
        this.textSupplier = textSupplier;
    }

    public Supplier<String> getTextSupplier() {
        return this.textSupplier;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public RGBA getColor() {
        return this.color;
    }

    public void setColor(RGBA color) {
        this.color = color;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.positionFactor = 1.0f / scale;
    }

    public void setTextChanged(Consumer<ScalingTextRenderer> textChanged) {
        this.textChanged = textChanged;
    }

    public float getTextWidth() {
        if (this.textWidth == -1) {
            this.setText(this.textSupplier.get());
        }
        return (float)this.textWidth * this.scale;
    }

    protected void setText(String newText) {
        if (newText != null && !newText.equals(this.text) || newText == null && this.text != null) {
            this.text = newText;
            this.textWidth = this.fontRenderer.func_78256_a(newText);
            this.updatedText();
        }
    }

    protected void updatedText() {
        this.textChanged.accept(this);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.setText(this.textSupplier.get());
        this.renderFont(matrixStack, this.fontRenderer, this.x, this.y);
    }

    protected void renderFont(MatrixStack matrixStack, FontRenderer fontRenderer, float x, float y) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(this.scale, this.scale, 0.0f);
        fontRenderer.func_228078_a_(this.text, x * this.positionFactor, y * this.positionFactor, this.color.getColorARGB(), matrixStack.func_227866_c_().func_227870_a_(), this.shadow, fontRenderer.func_78260_a());
        matrixStack.func_227865_b_();
    }
}

