/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.blocks.fluid;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageWrapperStorageDisk;
import de.melanx.extradisks.ServerConfig;
import de.melanx.extradisks.blocks.fluid.ExtraFluidStorageBlockTile;
import de.melanx.extradisks.items.fluid.ExtraFluidStorageType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;

public class ExtraFluidStorageNetworkNode
extends FluidStorageNetworkNode {
    public static final ResourceLocation BLOCK_FLUID_16384K_ID = new ResourceLocation("extradisks", "16384k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_65536K_ID = new ResourceLocation("extradisks", "65536k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_262144K_ID = new ResourceLocation("extradisks", "262144k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_1048576K_ID = new ResourceLocation("extradisks", "1048576k_fluid_storage_block");
    public static final ResourceLocation BLOCK_FLUID_INFINITE_ID = new ResourceLocation("extradisks", "infinite_fluid_storage_block");
    private final ExtraFluidStorageType type;
    private IStorageDisk<FluidStack> storage;

    public ExtraFluidStorageNetworkNode(World world, BlockPos pos, ExtraFluidStorageType type) {
        super(world, pos, null);
        this.type = type;
    }

    public static ResourceLocation getId(ExtraFluidStorageType type) {
        switch (type) {
            case TIER_5_FLUID: {
                return BLOCK_FLUID_16384K_ID;
            }
            case TIER_6_FLUID: {
                return BLOCK_FLUID_65536K_ID;
            }
            case TIER_7_FLUID: {
                return BLOCK_FLUID_262144K_ID;
            }
            case TIER_8_FLUID: {
                return BLOCK_FLUID_1048576K_ID;
            }
            case TIER_9_FLUID: {
                return BLOCK_FLUID_INFINITE_ID;
            }
        }
        throw new IllegalArgumentException("Unknown storage type " + (Object)((Object)type));
    }

    public ResourceLocation getId() {
        return ExtraFluidStorageNetworkNode.getId(this.type);
    }

    public int getEnergyUsage() {
        switch (this.type) {
            case TIER_5_FLUID: {
                return (Integer)ServerConfig.fluid_tier5usage.get();
            }
            case TIER_6_FLUID: {
                return (Integer)ServerConfig.fluid_tier6usage.get();
            }
            case TIER_7_FLUID: {
                return (Integer)ServerConfig.fluid_tier7usage.get();
            }
            case TIER_8_FLUID: {
                return (Integer)ServerConfig.fluid_tier8usage.get();
            }
            case TIER_9_FLUID: {
                return (Integer)ServerConfig.fluid_tier9usage.get();
            }
        }
        return 0;
    }

    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<FluidStack>)this.storage);
    }

    public void loadStorage(@Nullable PlayerEntity owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerWorld)this.world).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultFluidDisk((ServerWorld)this.world, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerWorld)this.world).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerWorld)this.world).markForSaving();
        }
        this.storage = new FluidStorageWrapperStorageDisk((FluidStorageNetworkNode)this, disk);
    }

    public IStorageDisk<FluidStack> getStorage() {
        return this.storage;
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("block.extradisks." + this.type.getName() + "_fluid_storage_block");
    }

    public long getStored() {
        return (Long)ExtraFluidStorageBlockTile.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

