/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.network;

import com.talhanation.smallships.entities.AbstractSailBoat;
import com.talhanation.smallships.network.Message;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSteerState
implements Message<MessageSteerState> {
    private boolean left;
    private boolean right;

    public MessageSteerState() {
    }

    public MessageSteerState(boolean left, boolean right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        Entity riding = context.getSender().func_184187_bx();
        if (!(riding instanceof AbstractSailBoat)) {
            return;
        }
        AbstractSailBoat sailBoat = (AbstractSailBoat)riding;
        if (context.getSender() == sailBoat.getDriver()) {
            sailBoat.setSteerState(this.left, this.right);
        }
    }

    @Override
    public MessageSteerState fromBytes(PacketBuffer buf) {
        this.left = buf.readBoolean();
        this.right = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
    }
}

