/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village.wanderer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BasicTrade;
import shadows.apotheosis.util.JsonUtil;
import shadows.apotheosis.village.VillageModule;
import shadows.apotheosis.village.wanderer.BasicTradeAdapter;
import shadows.placebo.util.json.ItemAdapter;
import shadows.placebo.util.json.NBTAdapter;

public class WandererTradeManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BasicTrade.class, (Object)BasicTradeAdapter.INSTANCE).registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundNBT.class, (Object)NBTAdapter.INSTANCE).create();
    public static final WandererTradeManager INSTANCE = new WandererTradeManager();
    protected final Map<ResourceLocation, BasicTrade> registry = new HashMap<ResourceLocation, BasicTrade>();
    protected final List<BasicTrade> normTrades = new ArrayList<BasicTrade>();
    protected final List<BasicTrade> rareTrades = new ArrayList<BasicTrade>();

    public WandererTradeManager() {
        super(GSON, "wanderer_trades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager mgr, IProfiler profiler) {
        this.normTrades.clear();
        this.rareTrades.clear();
        this.registry.clear();
        objects.forEach((id, obj) -> {
            try {
                if (!JsonUtil.checkAndLogEmpty(obj, id, "Wanderer Trade", VillageModule.LOGGER)) {
                    this.register((ResourceLocation)id, (BasicTrade)GSON.fromJson(obj, BasicTrade.class), obj.getAsJsonObject().has("rare"));
                }
            }
            catch (Exception e) {
                VillageModule.LOGGER.error("Failed to load Wandering Trader trade {}.", (Object)id.toString());
                e.printStackTrace();
            }
        });
        VillageModule.LOGGER.info("Loaded {} normal and {} rare Wandering Trader trade options.", (Object)this.normTrades.size(), (Object)this.rareTrades.size());
    }

    protected void register(ResourceLocation id, BasicTrade trade, boolean rare) {
        MerchantOffer offer = trade.func_221182_a(null, null);
        if (offer.func_222200_d() == null || offer.func_222200_d().func_190926_b() || offer.func_222214_i() == 0) {
            return;
        }
        if (!this.registry.containsKey(id)) {
            this.registry.put(id, trade);
            if (rare) {
                this.rareTrades.add(trade);
            } else {
                this.normTrades.add(trade);
            }
        } else {
            VillageModule.LOGGER.error("Attempted to register a wanderer trade with name {}, but it already exists!", (Object)id);
        }
    }

    public List<BasicTrade> getNormalTrades() {
        return this.normTrades;
    }

    public List<BasicTrade> getRareTrades() {
        return this.rareTrades;
    }
}

