/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.compat;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.spawn.compat.SpawnerCategory;
import shadows.apotheosis.spawn.compat.SpawnerWrapper;

@JeiPlugin
public class SpawnerJEIPlugin
implements IModPlugin {
    public static final String SPAWNER = "spawner_modification";

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        reg.addRecipes((Collection)ImmutableSet.of((Object)new SpawnerWrapper(SpawnerModifiers.MIN_DELAY, "MinSpawnDelay", "jei.spw.editmindelay"), (Object)new SpawnerWrapper(SpawnerModifiers.MAX_DELAY, "MaxSpawnDelay", "jei.spw.editmaxdelay"), (Object)new SpawnerWrapper(SpawnerModifiers.SPAWN_COUNT, "SpawnCount", "jei.spw.editspawncount"), (Object)new SpawnerWrapper(SpawnerModifiers.NEARBY_ENTITIES, "MaxNearbyEntities", "jei.spw.editnearby"), (Object)new SpawnerWrapper(SpawnerModifiers.PLAYER_DISTANCE, "RequiredPlayerRange", "jei.spw.editplayer"), (Object)new SpawnerWrapper(SpawnerModifiers.SPAWN_RANGE, "SpawnRange", "jei.spw.editspawn"), (Object[])new SpawnerWrapper[]{new SpawnerWrapper(SpawnerModifiers.CONDITIONS, "ignore_conditions", true, "jei.spw.ignoreconditions"), new SpawnerWrapper(SpawnerModifiers.PLAYERS, "ignore_players", true, "jei.spw.ignoreplayers"), new SpawnerWrapper(SpawnerModifiers.CAP, "ignore_cap", true, "jei.spw.ignorecap"), new SpawnerWrapper(SpawnerModifiers.REDSTONE, "redstone_control", true, "jei.spw.redstone"), new SpawnerWrapper(new ResourceLocation("witch"), "jei.spw.changeentity"), new SpawnerWrapper.SpawnerInverseWrapper()}), this.getPluginUid());
        reg.addIngredientInfo((Object)new ItemStack((IItemProvider)Blocks.field_150474_ac), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent("jei.spw.instructions", new Object[]{((IFormattableTextComponent)Enchantments.field_185306_r.func_200305_d(SpawnerModule.spawnerSilkLevel)).func_240699_a_(TextFormatting.DARK_BLUE).getString()})});
        for (Item i : ForgeRegistries.ITEMS) {
            if (!(i instanceof SpawnEggItem)) continue;
            reg.addIngredientInfo((Object)new ItemStack((IItemProvider)i), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent("jei.spw.capturing")});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150474_ac), new ResourceLocation[]{this.getPluginUid()});
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new SpawnerCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", SPAWNER);
    }
}

