/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.spawn.modifiers.CapModifier;
import shadows.apotheosis.spawn.modifiers.ConditionModifier;
import shadows.apotheosis.spawn.modifiers.EggModifier;
import shadows.apotheosis.spawn.modifiers.InverseModifier;
import shadows.apotheosis.spawn.modifiers.MaxDelayModifier;
import shadows.apotheosis.spawn.modifiers.MinDelayModifier;
import shadows.apotheosis.spawn.modifiers.ModifierSync;
import shadows.apotheosis.spawn.modifiers.NearbyEntityModifier;
import shadows.apotheosis.spawn.modifiers.PlayerDistModifier;
import shadows.apotheosis.spawn.modifiers.PlayerModifier;
import shadows.apotheosis.spawn.modifiers.RedstoneModifier;
import shadows.apotheosis.spawn.modifiers.SpawnCountModifier;
import shadows.apotheosis.spawn.modifiers.SpawnRangeModifier;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.placebo.config.Configuration;
import shadows.placebo.recipe.RecipeHelper;

public class SpawnerModifiers {
    public static final Map<String, SpawnerModifier> MODIFIERS = new HashMap<String, SpawnerModifier>();
    public static final SpawnerModifier MIN_DELAY = new MinDelayModifier();
    public static final SpawnerModifier MAX_DELAY = new MaxDelayModifier();
    public static final SpawnerModifier SPAWN_COUNT = new SpawnCountModifier();
    public static final SpawnerModifier NEARBY_ENTITIES = new NearbyEntityModifier();
    public static final SpawnerModifier PLAYER_DISTANCE = new PlayerDistModifier();
    public static final SpawnerModifier SPAWN_RANGE = new SpawnRangeModifier();
    public static final SpawnerModifier CONDITIONS = new ConditionModifier();
    public static final SpawnerModifier PLAYERS = new PlayerModifier();
    public static final SpawnerModifier CAP = new CapModifier();
    public static final SpawnerModifier REDSTONE = new RedstoneModifier();
    public static final EggModifier EGG = new EggModifier();
    public static final SpawnerModifier INVERSE = new InverseModifier();

    public static void registerModifiers() {
        SpawnerModifiers.register(MIN_DELAY);
        SpawnerModifiers.register(MAX_DELAY);
        SpawnerModifiers.register(SPAWN_COUNT);
        SpawnerModifiers.register(NEARBY_ENTITIES);
        SpawnerModifiers.register(PLAYER_DISTANCE);
        SpawnerModifiers.register(SPAWN_RANGE);
        SpawnerModifiers.register(CONDITIONS);
        SpawnerModifiers.register(PLAYERS);
        SpawnerModifiers.register(CAP);
        SpawnerModifiers.register(REDSTONE);
        SpawnerModifiers.register(EGG);
        SpawnerModifiers.register(INVERSE);
        for (SpawnerModifier modif : MODIFIERS.values()) {
            RecipeHelper.addRecipe((IRecipe)new ModifierSync.ModifierRecipe(modif));
        }
    }

    public static void reload(Configuration config) {
        for (SpawnerModifier modif : MODIFIERS.values()) {
            modif.load(config);
        }
    }

    public static LazyValue<Ingredient> readIngredient(String s) {
        if (s.startsWith("#")) {
            String tag = s.substring(1);
            return new LazyValue(() -> Ingredient.func_199805_a((ITag)TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(tag))));
        }
        String[] split = s.split(":");
        Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
        ItemStack stack = new ItemStack((IItemProvider)i);
        if (i == Items.field_221803_eL) {
            stack.func_200302_a((ITextComponent)new TranslationTextComponent("info.apoth.modifier_disabled"));
        }
        return new LazyValue(() -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
    }

    public static void register(SpawnerModifier modif) {
        if (MODIFIERS.containsKey(modif.getId())) {
            throw new RuntimeException("Tried to register a spawner modifier, but it is already registered!");
        }
        MODIFIERS.put(modif.getId(), modif);
    }
}

