/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.library;

import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public class EnchLibraryTile
extends TileEntity {
    protected final Object2ShortMap<Enchantment> points = new Object2ShortOpenHashMap();
    protected final Object2ByteMap<Enchantment> maxLevels = new Object2ByteOpenHashMap();
    protected final Set<EnchLibraryContainer> activeContainers = new HashSet<EnchLibraryContainer>();
    protected final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new EnchLibItemHandler());

    public EnchLibraryTile() {
        super(ApotheosisObjects.ENCH_LIB_TILE);
    }

    public void depositBook(ItemStack book) {
        if (book.func_77973_b() != Items.field_151134_bR) {
            return;
        }
        Map enchs = EnchantmentHelper.func_82781_a((ItemStack)book);
        for (Map.Entry e : enchs.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            short nVal = (short)(this.points.getShort(e.getKey()) + EnchLibraryTile.levelToPoints((Integer)e.getValue()));
            if (nVal < 0) {
                nVal = Short.MAX_VALUE;
            }
            this.points.put(e.getKey(), nVal);
            this.maxLevels.put(e.getKey(), (byte)Math.max(this.maxLevels.getByte(e.getKey()), ((Integer)e.getValue()).byteValue()));
        }
        if (enchs.size() > 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
        }
    }

    public void extractEnchant(ItemStack stack, Enchantment ench, int level) {
        int curLvl = EnchantmentHelper.func_82781_a((ItemStack)stack).getOrDefault(ench, 0);
        if (stack.func_190926_b() || !this.canExtract(ench, level, curLvl) || level == curLvl) {
            return;
        }
        Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
        enchs.put(ench, level);
        EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
        this.points.put((Object)ench, (short)(this.points.getShort((Object)ench) - EnchLibraryTile.levelToPoints(level) + EnchLibraryTile.levelToPoints(curLvl)));
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public boolean canExtract(Enchantment ench, int level, int currentLevel) {
        return this.maxLevels.getByte((Object)ench) >= level && this.points.getShort((Object)ench) >= EnchLibraryTile.levelToPoints(level) - EnchLibraryTile.levelToPoints(currentLevel);
    }

    public static short levelToPoints(int level) {
        return (short)Math.pow(2.0, level - 1);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT points = new CompoundNBT();
        for (Object2ShortMap.Entry e : this.points.object2ShortEntrySet()) {
            points.func_74777_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getShortValue());
        }
        tag.func_218657_a("Points", (INBT)points);
        CompoundNBT levels = new CompoundNBT();
        for (Object2ByteMap.Entry e : this.maxLevels.object2ByteEntrySet()) {
            levels.func_74774_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getByteValue());
        }
        tag.func_218657_a("Levels", (INBT)levels);
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        CompoundNBT points = tag.func_74775_l("Points");
        for (String s : points.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.func_74765_d(s));
        }
        CompoundNBT levels = tag.func_74775_l("Levels");
        for (String s : levels.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.func_74771_c(s));
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        CompoundNBT points = tag.func_74775_l("Points");
        for (String s : points.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.func_74765_d(s));
        }
        CompoundNBT levels = tag.func_74775_l("Levels");
        for (String s : levels.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.func_74771_c(s));
        }
        this.activeContainers.forEach(EnchLibraryContainer::onChanged);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -12, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        CompoundNBT points = new CompoundNBT();
        for (Object2ShortMap.Entry e : this.points.object2ShortEntrySet()) {
            points.func_74777_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getShortValue());
        }
        tag.func_218657_a("Points", (INBT)points);
        CompoundNBT levels = new CompoundNBT();
        for (Object2ByteMap.Entry e : this.maxLevels.object2ByteEntrySet()) {
            levels.func_74774_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getByteValue());
        }
        tag.func_218657_a("Levels", (INBT)levels);
        return tag;
    }

    public Object2ShortMap<Enchantment> getPointsMap() {
        return this.points;
    }

    public Object2ByteMap<Enchantment> getLevelsMap() {
        return this.maxLevels;
    }

    public void addListener(EnchLibraryContainer ctr) {
        this.activeContainers.add(ctr);
    }

    public void removeListener(EnchLibraryContainer ctr) {
        this.activeContainers.remove((Object)ctr);
    }

    public byte getMax(Enchantment ench) {
        return this.maxLevels.getByte((Object)ench);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private class EnchLibItemHandler
    implements IItemHandler {
        private EnchLibItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() != Items.field_151134_bR || stack.func_190916_E() > 1) {
                return stack;
            }
            if (!simulate) {
                EnchLibraryTile.this.depositBook(stack);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && stack.func_77973_b() == Items.field_151134_bR;
        }
    }
}

