/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.reload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraftforge.coremod.api.ASMAPI;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.gen.SpawnerItem;
import shadows.apotheosis.util.JsonUtil;
import shadows.apotheosis.util.WeightedSpawnerEntityAdapter;
import shadows.placebo.util.json.NBTAdapter;

public class RandomSpawnerManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(WeightedSpawnerEntity.class, (Object)new WeightedSpawnerEntityAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setFieldNamingStrategy(f -> f.getName().equals(ASMAPI.mapField((String)"field_76292_a")) ? "weight" : f.getName()).registerTypeAdapter(CompoundNBT.class, (Object)NBTAdapter.INSTANCE).create();
    public static final RandomSpawnerManager INSTANCE = new RandomSpawnerManager();
    private final List<SpawnerItem> entries = new ArrayList<SpawnerItem>();
    private final Map<ResourceLocation, SpawnerItem> registry = new HashMap<ResourceLocation, SpawnerItem>();
    private volatile int weight = 0;

    public RandomSpawnerManager() {
        super(GSON, "random_spawners");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.entries.clear();
        this.registry.clear();
        for (Map.Entry<ResourceLocation, JsonElement> obj : objects.entrySet()) {
            try {
                if (JsonUtil.checkAndLogEmpty(obj.getValue(), obj.getKey(), "Random Spawner", DeadlyModule.LOGGER)) continue;
                this.register(obj.getKey(), (SpawnerItem)((Object)GSON.fromJson(obj.getValue(), SpawnerItem.class)));
            }
            catch (Exception e) {
                DeadlyModule.LOGGER.error("Failed to load spawner item {}.", (Object)obj.getKey());
                e.printStackTrace();
            }
        }
        if (this.entries.size() == 0) {
            throw new RuntimeException("No Random Spawners were registered.  This is not supported.");
        }
        this.weight = WeightedRandom.func_76272_a(this.entries);
        if (this.weight == 0) {
            throw new RuntimeException("The total spawner weight is zero.  This is not supported.");
        }
        DeadlyModule.LOGGER.info("Loaded {} spawner items from resources.", (Object)this.entries.size());
    }

    protected void register(ResourceLocation id, SpawnerItem item) {
        if (!this.registry.containsKey(id)) {
            this.registry.put(id, item);
            this.entries.add(item);
        } else {
            DeadlyModule.LOGGER.error("Attempted to register a spawner item with name {}, but it already exists!", (Object)id);
        }
    }

    public SpawnerItem getRandomItem(Random rand) {
        return (SpawnerItem)WeightedRandom.func_76273_a((Random)rand, this.entries, (int)this.weight);
    }

    @Nullable
    public SpawnerItem getById(ResourceLocation id) {
        return this.registry.get(id);
    }
}

