/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.DeadlyModuleClient;
import shadows.apotheosis.deadly.DeadlyWorldGen;
import shadows.apotheosis.deadly.affix.AffixEvents;
import shadows.apotheosis.deadly.affix.LootRarity;
import shadows.apotheosis.deadly.affix.recipe.AffixShardingRecipe;
import shadows.apotheosis.deadly.affix.recipe.SoulfireCookingRecipe;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossDungeonFeature;
import shadows.apotheosis.deadly.gen.BossDungeonFeature2;
import shadows.apotheosis.deadly.gen.RogueSpawnerFeature;
import shadows.apotheosis.deadly.gen.TomeTowerFeature;
import shadows.apotheosis.deadly.gen.TroveFeature;
import shadows.apotheosis.deadly.objects.AffixTomeItem;
import shadows.apotheosis.deadly.objects.BossSpawnerBlock;
import shadows.apotheosis.deadly.objects.BossSummonerItem;
import shadows.apotheosis.deadly.objects.RarityShardItem;
import shadows.apotheosis.deadly.reload.AffixLootManager;
import shadows.apotheosis.deadly.reload.BossArmorManager;
import shadows.apotheosis.deadly.reload.BossItemManager;
import shadows.apotheosis.deadly.reload.RandomSpawnerManager;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.config.Configuration;
import shadows.placebo.recipe.RecipeHelper;

public class DeadlyModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Deadly");
    public static final EnumMap<LootRarity, RarityShardItem> RARITY_SHARDS = new EnumMap(LootRarity.class);
    public static final EnumMap<LootRarity, AffixTomeItem> RARITY_TOMES = new EnumMap(LootRarity.class);
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        MinecraftForge.EVENT_BUS.register((Object)new AffixEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, DeadlyWorldGen::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        DeadlyLoot.init();
        LootRarity[] vals = LootRarity.values();
        for (int i = 0; i < vals.length - 1; ++i) {
            RecipeHelper.addRecipe((IRecipe)new AffixShardingRecipe(new ResourceLocation("apotheosis", "affix_sharding_" + vals[i].name().toLowerCase(Locale.ROOT)), vals[i]));
            Apotheosis.HELPER.addShapeless((Object)new ItemStack((IItemProvider)RARITY_SHARDS.get((Object)vals[i]), 2), new Object[]{new ItemStack((IItemProvider)RARITY_SHARDS.get((Object)vals[i + 1]))});
        }
        RecipeHelper.addRecipe((IRecipe)new AffixShardingRecipe(new ResourceLocation("apotheosis", "affix_sharding_" + LootRarity.ANCIENT.name().toLowerCase(Locale.ROOT)), LootRarity.ANCIENT));
        Color.field_240739_b_ = new HashMap(Color.field_240739_b_);
        Color.field_240739_b_.put("rainbow", new DeadlyModuleClient.RainbowColor());
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
        e.getRegistry().register(BossDungeonFeature.INSTANCE.setRegistryName("boss_dungeon"));
        e.getRegistry().register(BossDungeonFeature2.INSTANCE.setRegistryName("boss_dungeon_2"));
        e.getRegistry().register(RogueSpawnerFeature.INSTANCE.setRegistryName("rogue_spawner"));
        e.getRegistry().register(TroveFeature.INSTANCE.setRegistryName("trove"));
        e.getRegistry().register(TomeTowerFeature.INSTANCE.setRegistryName("tome_tower"));
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new BossSummonerItem(new Item.Properties().func_200917_a(1).func_200916_a(Apotheosis.APOTH_GROUP)).setRegistryName("boss_summoner"));
        for (LootRarity r : LootRarity.values()) {
            RarityShardItem shard = new RarityShardItem(r, new Item.Properties().func_200916_a(Apotheosis.APOTH_GROUP));
            shard.setRegistryName(r.name().toLowerCase(Locale.ROOT) + "_shard");
            e.getRegistry().register((IForgeRegistryEntry)shard);
            RARITY_SHARDS.put(r, shard);
        }
        for (LootRarity r : LootRarity.values()) {
            AffixTomeItem tome = new AffixTomeItem(r, new Item.Properties().func_200916_a(Apotheosis.APOTH_GROUP));
            tome.setRegistryName(r.name().toLowerCase(Locale.ROOT) + "_tome");
            e.getRegistry().register((IForgeRegistryEntry)tome);
            RARITY_TOMES.put(r, tome);
        }
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register(new BossSpawnerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(-1.0f).func_222380_e().func_226896_b_()).setRegistryName("boss_spawner"));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().register(new TileEntityType(BossSpawnerBlock.BossSpawnerTile::new, (Set)ImmutableSet.of((Object)((Object)ApotheosisObjects.BOSS_SPAWNER)), null).setRegistryName("boss_spawn_tile"));
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)AffixShardingRecipe.SERIALIZER.setRegistryName(new ResourceLocation("apotheosis", "affix_sharding")));
        e.getRegistry().register((IForgeRegistryEntry)SoulfireCookingRecipe.SERIALIZER.setRegistryName(new ResourceLocation("apotheosis", "soulfire_cooking")));
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(DeadlyModuleClient::init);
    }

    public void reloads(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)AffixLootManager.INSTANCE);
        e.addListener((IFutureReloadListener)BossArmorManager.INSTANCE);
        e.addListener((IFutureReloadListener)BossItemManager.INSTANCE);
        e.addListener((IFutureReloadListener)RandomSpawnerManager.INSTANCE);
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        DeadlyConfig.config = new Configuration(new File(Apotheosis.configDir, "deadly.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        DeadlyConfig.loadConfigs();
        NameHelper.load(nameConfig);
        if (e == null && DeadlyConfig.config.hasChanged()) {
            DeadlyConfig.config.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }
}

