/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.state;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;

@ParametersAreNonnullByDefault
public class CTMContext {
    private final IBlockReader world;
    private final BlockPos pos;
    @Nullable
    private RenderContextList ctxCache;

    public CTMContext(IBlockReader world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public CTMContext(CTMContext parent) {
        this(parent.world, parent.pos);
    }

    public RenderContextList getContextList(BlockState state, AbstractCTMBakedModel model) {
        if (this.ctxCache == null) {
            this.ctxCache = new RenderContextList(state, model.getCTMTextures(), this.world, this.pos);
        }
        return this.ctxCache;
    }

    public IBlockReader getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

