/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeWirelessTransmitter.mixin;

import com.YTrollman.CreativeWirelessTransmitter.node.IPlaceHolder;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemProvider;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.item.NetworkItemManager;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={NetworkItemManager.class}, remap=false)
public abstract class MixinNetworkItemManager
implements INetworkItemManager {
    private final INetwork network;
    private final Map<PlayerEntity, INetworkItem> items = new ConcurrentHashMap<PlayerEntity, INetworkItem>();

    public MixinNetworkItemManager(INetwork network) {
        this.network = network;
    }

    @Overwrite
    public void open(PlayerEntity player, ItemStack stack, PlayerSlot slot) {
        boolean inRange = false;
        for (INetworkNodeGraphEntry entry : this.network.getNodeGraph().all()) {
            INetworkNode node = entry.getNode();
            if (node instanceof IWirelessTransmitter && this.network.canRun() && node.isActive() && ((IWirelessTransmitter)node).getDimension() == player.func_130014_f_().func_234923_W_()) {
                IWirelessTransmitter transmitter = (IWirelessTransmitter)node;
                Vector3d pos = player.func_213303_ch();
                double distance = Math.sqrt(Math.pow((double)transmitter.getOrigin().func_177958_n() - pos.func_82615_a(), 2.0) + Math.pow((double)transmitter.getOrigin().func_177956_o() - pos.func_82617_b(), 2.0) + Math.pow((double)transmitter.getOrigin().func_177952_p() - pos.func_82616_c(), 2.0));
                if (!(distance < (double)transmitter.getRange())) continue;
                inRange = true;
                break;
            }
            if (!(node instanceof IWirelessTransmitter) || !this.network.canRun() || !node.isActive() || ((IWirelessTransmitter)node).getDimension() == player.func_130014_f_().func_234923_W_() || !(node instanceof IPlaceHolder)) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.refinedstorage.network_item.out_of_range"), player.func_110124_au());
            return;
        }
        INetworkItem item = ((INetworkItemProvider)stack.func_77973_b()).provide((INetworkItemManager)this, player, stack, slot);
        if (item.onOpen(this.network)) {
            this.items.put(player, item);
        }
    }
}

