/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeWirelessTransmitter.datageneration;

import com.YTrollman.CreativeWirelessTransmitter.datageneration.BlockModelGenerator;
import com.refinedmods.refinedstorage.block.BlockDirection;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockModels {
    private final BlockModelGenerator generator;

    public BlockModels(BlockModelGenerator blockModelGenerator) {
        this.generator = blockModelGenerator;
    }

    public void simpleBlockStateModel(Block block, Function<BlockState, ModelFile> model) {
        this.generator.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model.apply((BlockState)state)).build());
    }

    public void anyDirectionalRSBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.generator.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockDirection.ANY.getProperty());
            int xRotation = 0;
            if (dir == Direction.DOWN) {
                xRotation = 180;
            }
            if (dir.func_176740_k().func_176722_c()) {
                xRotation = 90;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(xRotation).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + angleOffset) % 360).build();
        });
    }

    public void CreativeWirelessTransmitterBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.generator.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockDirection.ANY.getProperty());
            int xRotation = dir.func_176740_k() == Direction.Axis.Y ? (dir == Direction.UP ? 180 : 0) : (dir.func_176740_k().func_176722_c() ? 90 : 0);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(xRotation).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + angleOffset) % 360).build();
        });
    }

    public void horizontalRSBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.generator.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.func_177229_b((Property)BlockDirection.HORIZONTAL.getProperty())).func_185119_l() + angleOffset) % 360).build());
    }

    public BlockModelBuilder createCreativeWirelessTransmitterModel(String name, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("creativewirelesstransmitter", "creative_wireless_transmitter"))).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeCutoutModel(String name, ResourceLocation down, ResourceLocation downCutout, ResourceLocation up, ResourceLocation upCutout, ResourceLocation east, ResourceLocation eastCutout, ResourceLocation west, ResourceLocation westCutout, ResourceLocation north, ResourceLocation northCutout, ResourceLocation south, ResourceLocation southCutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("creativewirelesstransmitter", "cube_cutout"))).texture("particle", north)).texture("east", east)).texture("south", south)).texture("west", west)).texture("up", up)).texture("down", down)).texture("north", north)).texture("cutout_down", downCutout)).texture("cutout_east", eastCutout)).texture("cutout_west", westCutout)).texture("cutout_south", southCutout)).texture("cutout_north", northCutout)).texture("cutout_up", upCutout);
    }

    public BlockModelBuilder createControllerNearlyCutoutModel(String name, ResourceLocation particle, ResourceLocation all, ResourceLocation grayCutout, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("creativewirelesstransmitter", "block/controller_nearly"))).texture("particle", particle)).texture("all", all)).texture("cutout_gray", grayCutout)).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeAllCutoutModel(String name, ResourceLocation particle, ResourceLocation all, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("creativewirelesstransmitter", "cube_all_cutout"))).texture("particle", particle)).texture("all", all)).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeNorthCutoutModel(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west, ResourceLocation particle, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("creativewirelesstransmitter", "cube_north_cutout"))).texture("particle", particle)).texture("east", east)).texture("south", south)).texture("west", west)).texture("up", up)).texture("down", down)).texture("north", north)).texture("cutout", cutout);
    }
}

