/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeTileEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.MobEntity;
import net.minecraftforge.fml.InterModComms;

public class IEIMCHandler {
    private static final HashMap<String, Consumer<InterModComms.IMCMessage>> MESSAGE_HANDLERS = new HashMap();

    public static void init() {
        MESSAGE_HANDLERS.put("fluidpipe_cover", imcMessage -> {
            Predicate func = (Predicate)imcMessage.getMessageSupplier().get();
            FluidPipeTileEntity.validPipeCovers.add(func);
        });
        MESSAGE_HANDLERS.put("fluidpipe_cover_climb", imcMessage -> {
            Predicate func = (Predicate)imcMessage.getMessageSupplier().get();
            FluidPipeTileEntity.climbablePipeCovers.add(func);
        });
        MESSAGE_HANDLERS.put("shaderbag_exclude", imcMessage -> {
            String s = (String)imcMessage.getMessageSupplier().get();
            try {
                Class<?> clazz = Class.forName(s);
                if (MobEntity.class.isAssignableFrom(clazz)) {
                    EventHandler.listOfBoringBosses.add(clazz);
                } else {
                    IELogger.error("IMC Handling: " + s + " is not an instance of EntityLiving.");
                }
            }
            catch (ClassNotFoundException e) {
                IELogger.error("IMC Handling: " + s + " is not a valid classname.");
            }
        });
    }

    public static void handleIMCMessages(Stream<InterModComms.IMCMessage> messages) {
        messages.forEach(message -> {
            if (MESSAGE_HANDLERS.containsKey(message.getMethod())) {
                Consumer<InterModComms.IMCMessage> handler = MESSAGE_HANDLERS.get(message.getMethod());
                handler.accept((InterModComms.IMCMessage)message);
            }
        });
    }
}

