/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CachedConfig {
    private final List<ConfigValue<?>> value;
    private final ForgeConfigSpec spec;

    private CachedConfig(List<ConfigValue<?>> value, ForgeConfigSpec spec) {
        this.value = value;
        this.spec = spec;
    }

    public void refreshCached() {
        this.value.forEach(ConfigValue::refresh);
    }

    public boolean reloadIfMatched(ModConfig.ModConfigEvent ev, ModConfig.Type configType) {
        if (ev.getConfig().getModId().equals("immersiveengineering") && ev.getConfig().getType() == configType) {
            this.refreshCached();
            return true;
        }
        return false;
    }

    public ForgeConfigSpec getBaseSpec() {
        return this.spec;
    }

    public static class Builder {
        private final ForgeConfigSpec.Builder inner;
        private final List<ConfigValue<?>> values = new ArrayList();

        public Builder() {
            this.inner = new ForgeConfigSpec.Builder();
        }

        public Builder comment(String ... comment) {
            this.inner.comment(comment);
            return this;
        }

        public Builder worldRestart() {
            this.inner.worldRestart();
            return this;
        }

        public Builder push(String ... names) {
            this.inner.push((List)ImmutableList.copyOf((Object[])names));
            return this;
        }

        public Builder pop() {
            this.inner.pop();
            return this;
        }

        public Builder pop(int count) {
            this.inner.pop(count);
            return this;
        }

        public <T> ConfigValue<T> define(String name, T defValue) {
            return new ConfigValue(this, this.inner.define(name, defValue));
        }

        public BooleanValue define(String name, boolean def) {
            return new BooleanValue(this, this.inner.define(name, def));
        }

        public DoubleValue defineInRange(String name, double def, double min, double max) {
            return new DoubleValue(this, this.inner.defineInRange(name, def, min, max));
        }

        public IntValue defineInRange(String name, int def, int min, int max) {
            return new IntValue(this, this.inner.defineInRange(name, def, min, max));
        }

        public <T> ConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            return new ConfigValue<List<? extends T>>(this, this.inner.defineList(path, defaultValue, elementValidator));
        }

        public CachedConfig build() {
            return new CachedConfig(this.values, this.inner.build());
        }

        public Builder push(ImmutableList<String> of) {
            this.inner.push(of);
            return this;
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean> {
        BooleanValue(Builder builder, ForgeConfigSpec.BooleanValue base) {
            super(builder, base);
        }
    }

    public static class DoubleValue
    extends ConfigValue<Double>
    implements DoubleSupplier {
        DoubleValue(Builder builder, ForgeConfigSpec.DoubleValue base) {
            super(builder, base);
        }

        @Override
        public double getAsDouble() {
            return (Double)this.get();
        }
    }

    public static class IntValue
    extends ConfigValue<Integer> {
        IntValue(Builder builder, ForgeConfigSpec.IntValue base) {
            super(builder, base);
        }
    }

    public static class ConfigValue<T>
    implements Supplier<T> {
        private final ForgeConfigSpec.ConfigValue<T> baseValue;
        private T cached;

        public ConfigValue(Builder builder, ForgeConfigSpec.ConfigValue<T> baseValue) {
            this.baseValue = baseValue;
            builder.values.add(this);
        }

        @Override
        @Nonnull
        public T get() {
            return Objects.requireNonNull(this.cached);
        }

        public void refresh() {
            this.cached = this.baseValue.get();
        }

        public ForgeConfigSpec.ConfigValue<T> getBase() {
            return this.baseValue;
        }

        public T getOr(T valueDuringStartup) {
            if (this.cached != null) {
                return this.cached;
            }
            return valueDuringStartup;
        }

        public T getOrDefault() {
            return (T)this.getOr(this.baseValue.get());
        }
    }
}

