/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IETileProviderBlock;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class DeskBlock<T extends TileEntity>
extends IETileProviderBlock<T> {
    private static final CachedShapesWithTransform<Boolean, Direction> SHAPES = CachedShapesWithTransform.createDirectional(b -> {
        double xMin = b != false ? 0.0 : 0.0625;
        double xMax = xMin + 0.9375;
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(xMin, 0.0, 0.0625, xMax, 0.8125, 0.9375));
    });
    public static final Property<Direction> FACING = IEProperties.FACING_HORIZONTAL;
    public static final Property<Boolean> DUMMY = IEProperties.MULTIBLOCKSLAVE;

    public DeskBlock(String name, RegistryObject<TileEntityType<T>> tileType) {
        super(name, tileType, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(2.0f, 5.0f).func_226896_b_());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DUMMY, FACING, BlockStateProperties.field_208198_y});
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        Direction newFacing = rot.func_185831_a((Direction)state.func_177229_b(FACING));
        return (BlockState)state.func_206870_a(FACING, (Comparable)newFacing);
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        if (mirrorIn == Mirror.NONE) {
            return state;
        }
        Direction oldFacing = (Direction)state.func_177229_b(FACING);
        Direction newFacing = mirrorIn.func_185803_b(oldFacing);
        boolean oldDummy = (Boolean)state.func_177229_b(DUMMY);
        boolean newDummy = !oldDummy;
        return (BlockState)((BlockState)state.func_206870_a(FACING, (Comparable)newFacing)).func_206870_a(DUMMY, (Comparable)Boolean.valueOf(newDummy));
    }

    @Override
    public boolean canIEBlockBePlaced(BlockState newState, BlockItemUseContext context) {
        BlockPos start = context.func_195995_a();
        return DeskBlock.areAllReplaceable(start, start.func_177981_b(2), context);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction updateSide, BlockState updatedState, IWorld worldIn, BlockPos currentPos, BlockPos updatedPos) {
        Direction facing = (Direction)stateIn.func_177229_b(FACING);
        boolean dummy = (Boolean)stateIn.func_177229_b(DUMMY);
        BlockPos otherHalf = currentPos.func_177967_a(facing.func_176746_e(), dummy ? -1 : 1);
        BlockState otherState = worldIn.func_180495_p(otherHalf);
        if (otherState.func_177230_c() == this && otherState.func_177229_b(FACING) == facing && (Boolean)otherState.func_177229_b(DUMMY) == !dummy) {
            return stateIn;
        }
        for (Direction candidate : FACING.func_177700_c()) {
            BlockPos otherHalf2;
            BlockState otherState2;
            if (candidate == facing || (otherState2 = worldIn.func_180495_p(otherHalf2 = currentPos.func_177967_a(candidate.func_176746_e(), dummy ? -1 : 1))).func_177230_c() != this || otherState2.func_177229_b(FACING) != candidate || (Boolean)otherState2.func_177229_b(DUMMY) != !dummy) continue;
            return (BlockState)stateIn.func_206870_a(FACING, (Comparable)candidate);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static Direction getDeskDummyOffset(World world, BlockPos pos, Direction facing, BlockItemUseContext ctx) {
        Direction dummyDir = facing.func_176740_k() == Direction.Axis.X ? (ctx.func_221532_j().field_72449_c < 0.5 ? Direction.NORTH : Direction.SOUTH) : (ctx.func_221532_j().field_72450_a < 0.5 ? Direction.WEST : Direction.EAST);
        BlockPos dummyPos = pos.func_177972_a(dummyDir);
        if (!world.func_180495_p(dummyPos).func_196953_a(BlockItemUseContext.func_221536_a((BlockItemUseContext)ctx, (BlockPos)dummyPos, (Direction)dummyDir))) {
            dummyDir = dummyDir.func_176734_d();
        }
        return dummyDir;
    }

    public static void placeDummies(BlockState state, World world, BlockPos pos, BlockItemUseContext ctx) {
        boolean mirror;
        Direction facing = (Direction)state.func_177229_b(FACING);
        Direction dummyDir = DeskBlock.getDeskDummyOffset(world, pos, facing, ctx);
        BlockPos dummyPos = pos.func_177972_a(dummyDir);
        boolean bl = mirror = dummyDir != facing.func_176746_e();
        if (mirror) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(DUMMY, (Comparable)Boolean.valueOf(true)));
        }
        world.func_175656_a(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(!mirror)), world, pos));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES.get((Boolean)state.func_177229_b(DUMMY), (Direction)state.func_177229_b(FACING));
    }
}

