/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.customslots;

import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemCapability;
import dev.gigaherz.toolbelt.customslots.IExtensionContainer;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ExtensionSlotItemHandler
implements IExtensionSlot {
    protected final IExtensionContainer owner;
    protected final ResourceLocation slotType;
    protected final int slot;
    protected final IItemHandlerModifiable inventory;

    public ExtensionSlotItemHandler(IExtensionContainer owner, ResourceLocation slotType, IItemHandlerModifiable inventory, int slot) {
        this.owner = owner;
        this.slotType = slotType;
        this.slot = slot;
        this.inventory = inventory;
    }

    @Override
    @Nonnull
    public IExtensionContainer getContainer() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ResourceLocation getType() {
        return this.slotType;
    }

    @Override
    @Nonnull
    public ItemStack getContents() {
        return this.inventory.getStackInSlot(this.slot);
    }

    @Override
    public void setContents(@Nonnull ItemStack stack) {
        ItemStack oldStack = this.getContents();
        if (oldStack == stack) {
            return;
        }
        if (!oldStack.func_190926_b()) {
            this.notifyUnequip(oldStack);
        }
        this.inventory.setStackInSlot(this.slot, stack);
        if (!stack.func_190926_b()) {
            this.notifyEquip(stack);
        }
    }

    @Override
    public void onContentsChanged() {
        this.owner.onContentsChanged(this);
    }

    private void notifyEquip(ItemStack stack) {
        stack.getCapability(ExtensionSlotItemCapability.INSTANCE, null).ifPresent(extItem -> extItem.onEquipped(stack, this));
    }

    private void notifyUnequip(ItemStack stack) {
        stack.getCapability(ExtensionSlotItemCapability.INSTANCE, null).ifPresent(extItem -> extItem.onUnequipped(stack, this));
    }

    public void onWornTick() {
        ItemStack stack = this.getContents();
        if (stack.func_190926_b()) {
            return;
        }
        stack.getCapability(ExtensionSlotItemCapability.INSTANCE, null).ifPresent(extItem -> extItem.onWornTick(stack, this));
    }
}

