/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import dev.gigaherz.toolbelt.ConfigData;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolBeltInventory
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    ToolBeltInventory(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    private CompoundNBT getTag() {
        CompoundNBT tag = this.itemStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            this.itemStack.func_77982_d(tag);
        }
        return tag;
    }

    public int getSlots() {
        return MathHelper.func_76125_a((int)this.getTag().func_74762_e("Size"), (int)2, (int)9);
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ListNBT tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            if (itemTags.func_74762_e("Slot") != slot) continue;
            return ItemStack.func_199557_a((CompoundNBT)itemTags);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        boolean hasStack;
        this.validateSlotIndex(slot);
        CompoundNBT itemTag = null;
        boolean bl = hasStack = stack.func_190916_E() > 0;
        if (hasStack) {
            itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", slot);
            stack.func_77955_b(itemTag);
        }
        ListNBT tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT existing = tagList.func_150305_b(i);
            if (existing.func_74762_e("Slot") != slot) continue;
            if (hasStack) {
                tagList.set(i, (INBT)itemTag);
            } else {
                tagList.remove(i);
            }
            return;
        }
        if (hasStack) {
            tagList.add((Object)itemTag);
        }
        this.getTag().func_218657_a("Items", (INBT)tagList);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        if (stack.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.func_77976_d();
        if (existing.func_190916_E() > 0) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190916_E() <= 0) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    protected boolean canInsertItem(int slot, ItemStack stack) {
        return ConfigData.isItemStackAllowed(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

