/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.forge.api.Expandable;
import me.shedaniel.clothconfig2.forge.api.Tooltip;
import me.shedaniel.clothconfig2.forge.gui.entries.BaseListCell;
import me.shedaniel.clothconfig2.forge.gui.entries.TooltipListEntry;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseListEntry<T, C extends BaseListCell, SELF extends BaseListEntry<T, C, SELF>>
extends TooltipListEntry<List<T>>
implements Expandable {
    protected static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    protected final @NotNull List<C> cells;
    protected final @NotNull List<IGuiEventListener> widgets;
    protected boolean expanded;
    protected boolean deleteButtonEnabled;
    protected boolean insertInFront;
    protected @Nullable Consumer<List<T>> saveConsumer;
    protected ListLabelWidget labelWidget;
    protected Widget resetWidget;
    protected @NotNull Function<SELF, C> createNewInstance;
    protected @NotNull Supplier<List<T>> defaultValue;
    protected @Nullable ITextComponent addTooltip = new TranslationTextComponent("text.cloth-config.list.add");
    protected @Nullable ITextComponent removeTooltip = new TranslationTextComponent("text.cloth-config.list.remove");

    public BaseListEntry(@NotNull ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier, @NotNull Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, ITextComponent resetButtonKey) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, false);
    }

    public BaseListEntry(@NotNull ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier, @NotNull Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, ITextComponent resetButtonKey, boolean requiresRestart) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, requiresRestart, true, true);
    }

    public BaseListEntry(@NotNull ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier, @NotNull Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, ITextComponent resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.deleteButtonEnabled = deleteButtonEnabled;
        this.insertInFront = insertInFront;
        this.cells = Lists.newArrayList();
        this.labelWidget = new ListLabelWidget();
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.labelWidget});
        this.resetWidget = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)resetButtonKey) + 6, 20, resetButtonKey, widget -> {
            this.widgets.removeAll(this.cells);
            for (BaseListCell cell : this.cells) {
                cell.onDelete();
            }
            this.cells.clear();
            ((List)defaultValue.get()).stream().map(this::getFromValue).forEach(this.cells::add);
            for (BaseListCell cell : this.cells) {
                cell.onAdd();
            }
            this.widgets.addAll(this.cells);
        });
        this.widgets.add((IGuiEventListener)this.resetWidget);
        this.saveConsumer = saveConsumer;
        this.createNewInstance = createNewInstance;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isEdited() {
        if (super.isEdited()) {
            return true;
        }
        if (this.cells.stream().anyMatch(BaseListCell::isEdited)) {
            return true;
        }
        List value = (List)this.getValue();
        List<T> defaultValue = this.defaultValue.get();
        if (value.size() != defaultValue.size()) {
            return true;
        }
        for (int i = 0; i < value.size(); ++i) {
            if (Objects.equals(value.get(i), defaultValue.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequiresRestart() {
        return this.cells.stream().anyMatch(BaseListCell::isRequiresRestart);
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    public abstract SELF self();

    public boolean isDeleteButtonEnabled() {
        return this.deleteButtonEnabled;
    }

    protected abstract C getFromValue(T var1);

    public @NotNull Function<SELF, C> getCreateNewInstance() {
        return this.createNewInstance;
    }

    public void setCreateNewInstance(@NotNull Function<SELF, C> createNewInstance) {
        this.createNewInstance = createNewInstance;
    }

    public @Nullable ITextComponent getAddTooltip() {
        return this.addTooltip;
    }

    public void setAddTooltip(@Nullable ITextComponent addTooltip) {
        this.addTooltip = addTooltip;
    }

    public @Nullable ITextComponent getRemoveTooltip() {
        return this.removeTooltip;
    }

    public void setRemoveTooltip(@Nullable ITextComponent removeTooltip) {
        this.removeTooltip = removeTooltip;
    }

    @Override
    public Optional<List<T>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public int getItemHeight() {
        if (this.expanded) {
            int i = 24;
            for (BaseListCell entry : this.cells) {
                i += entry.getCellHeight();
            }
            return i;
        }
        return 24;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        if (!this.expanded) {
            ArrayList<IGuiEventListener> elements = new ArrayList<IGuiEventListener>(this.widgets);
            elements.removeAll(this.cells);
            return elements;
        }
        return this.widgets;
    }

    @Override
    public Optional<ITextComponent> getError() {
        List errors = this.cells.stream().map(BaseListCell::getConfigError).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (errors.size() > 1) {
            return Optional.of(new TranslationTextComponent("text.cloth-config.multi_error"));
        }
        return errors.stream().findFirst();
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        this.labelWidget.rectangle.x = x - 15;
        this.labelWidget.rectangle.y = y;
        this.labelWidget.rectangle.width = entryWidth + 15;
        this.labelWidget.rectangle.height = 24;
        return this.labelWidget.rectangle.contains(mouseX, mouseY) && this.getParent().func_231047_b_(mouseX, mouseY) && !this.resetWidget.func_231047_b_((double)mouseX, (double)mouseY);
    }

    protected boolean isInsideCreateNew(double mouseX, double mouseY) {
        return mouseX >= (double)(this.labelWidget.rectangle.x + 12) && mouseY >= (double)(this.labelWidget.rectangle.y + 3) && mouseX <= (double)(this.labelWidget.rectangle.x + 12 + 11) && mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11);
    }

    protected boolean isInsideDelete(double mouseX, double mouseY) {
        return this.isDeleteButtonEnabled() && mouseX >= (double)(this.labelWidget.rectangle.x + 25) && mouseY >= (double)(this.labelWidget.rectangle.y + 3) && mouseX <= (double)(this.labelWidget.rectangle.x + 25 + 11) && mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11);
    }

    public Optional<ITextComponent[]> getTooltip(int mouseX, int mouseY) {
        if (this.addTooltip != null && this.isInsideCreateNew(mouseX, mouseY)) {
            return Optional.of(new ITextComponent[]{this.addTooltip});
        }
        if (this.removeTooltip != null && this.isInsideDelete(mouseX, mouseY)) {
            return Optional.of(new ITextComponent[]{this.removeTooltip});
        }
        if (this.getTooltipSupplier() != null) {
            return this.getTooltipSupplier().get();
        }
        return Optional.empty();
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        Optional<ITextComponent[]> tooltip;
        this.labelWidget.rectangle.x = x - 19;
        this.labelWidget.rectangle.y = y;
        this.labelWidget.rectangle.width = entryWidth + 19;
        this.labelWidget.rectangle.height = 24;
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip(mouseX, mouseY)).isPresent() && tooltip.get().length > 0) {
            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), tooltip.get()));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CONFIG_TEX);
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BaseListCell focused = !this.expanded || this.func_241217_q_() == null || !(this.func_241217_q_() instanceof BaseListCell) ? null : (BaseListCell)this.func_241217_q_();
        boolean insideCreateNew = this.isInsideCreateNew(mouseX, mouseY);
        boolean insideDelete = this.isInsideDelete(mouseX, mouseY);
        this.func_238474_b_(matrices, x - 15, y + 4, 33, (this.labelWidget.rectangle.contains(mouseX, mouseY) && !insideCreateNew && !insideDelete ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        this.func_238474_b_(matrices, x - 15 + 13, y + 4, 42, insideCreateNew ? 9 : 0, 9, 9);
        if (this.isDeleteButtonEnabled()) {
            this.func_238474_b_(matrices, x - 15 + 26, y + 4, 51, focused == null ? 0 : (insideDelete ? 18 : 9), 9, 9);
        }
        this.resetWidget.field_230690_l_ = x + entryWidth - this.resetWidget.func_230998_h_();
        this.resetWidget.field_230691_m_ = y;
        this.resetWidget.field_230693_o_ = this.isEdited();
        this.resetWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
        Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.getDisplayedFieldName().func_241878_f(), this.isDeleteButtonEnabled() ? (float)(x + 24) : (float)(x + 24 - 9), (float)(y + 5), this.labelWidget.rectangle.contains(mouseX, mouseY) && !this.resetWidget.func_231047_b_((double)mouseX, (double)mouseY) && !insideDelete && !insideCreateNew ? -1638890 : this.getPreferredTextColor());
        if (this.expanded) {
            int yy = y + 24;
            for (BaseListCell cell : this.cells) {
                cell.render(matrices, -1, yy, x + 14, entryWidth - 14, cell.getCellHeight(), mouseX, mouseY, this.getParent().getListener() != null && ((AbstractConfigEntry)this.getParent().getListener()).equals(this) && this.func_241217_q_() != null && this.func_241217_q_().equals((Object)cell), delta);
                yy += cell.getCellHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (BaseListCell cell : this.cells) {
            cell.updateSelected(isSelected && this.func_241217_q_() == cell && this.expanded);
        }
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    public boolean insertInFront() {
        return this.insertInFront;
    }

    public class ListLabelWidget
    implements IGuiEventListener {
        protected Rectangle rectangle = new Rectangle();

        public boolean func_231044_a_(double double_1, double double_2, int int_1) {
            if (BaseListEntry.this.resetWidget.func_231047_b_(double_1, double_2)) {
                return false;
            }
            if (BaseListEntry.this.isInsideCreateNew(double_1, double_2)) {
                BaseListCell cell;
                BaseListEntry.this.expanded = true;
                if (BaseListEntry.this.insertInFront()) {
                    cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(0, cell);
                    BaseListEntry.this.widgets.add(0, (IGuiEventListener)cell);
                } else {
                    cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(cell);
                    BaseListEntry.this.widgets.add((IGuiEventListener)cell);
                }
                cell.onAdd();
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            if (BaseListEntry.this.isDeleteButtonEnabled() && BaseListEntry.this.isInsideDelete(double_1, double_2)) {
                IGuiEventListener focused = BaseListEntry.this.func_241217_q_();
                if (BaseListEntry.this.expanded && focused instanceof BaseListCell) {
                    ((BaseListCell)focused).onDelete();
                    BaseListEntry.this.cells.remove(focused);
                    BaseListEntry.this.widgets.remove(focused);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                }
                return true;
            }
            if (this.rectangle.contains(double_1, double_2)) {
                BaseListEntry.this.expanded = !BaseListEntry.this.expanded;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

