/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.tools;

import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ReflectionHelper {
    public static <FIELDHOLDER, FIELDTYPE> Function<FIELDHOLDER, FIELDTYPE> getInstanceFieldGetter(Class<FIELDHOLDER> fieldHolderClass, String fieldName) {
        Field field = ObfuscationReflectionHelper.findField(fieldHolderClass, (String)fieldName);
        return ReflectionHelper.getInstanceFieldGetter(field);
    }

    public static <FIELDHOLDER, FIELDTYPE> MutableInstanceField<FIELDHOLDER, FIELDTYPE> getInstanceField(Class<FIELDHOLDER> fieldHolderClass, String fieldName) {
        return new MutableInstanceField(fieldHolderClass, fieldName);
    }

    private static <FIELDHOLDER, FIELDTYPE> Function<FIELDHOLDER, FIELDTYPE> getInstanceFieldGetter(Field field) {
        return instance -> {
            try {
                return field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static <FIELDHOLDER, FIELDTYPE> BiConsumer<FIELDHOLDER, FIELDTYPE> getInstanceFieldSetter(Field field) {
        return (instance, value) -> {
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static class MutableInstanceField<FIELDHOLDER, FIELDTYPE> {
        private final Function<FIELDHOLDER, FIELDTYPE> getter;
        private final BiConsumer<FIELDHOLDER, FIELDTYPE> setter;

        private MutableInstanceField(Class<FIELDHOLDER> fieldHolderClass, String fieldName) {
            Field field = ObfuscationReflectionHelper.findField(fieldHolderClass, (String)fieldName);
            this.getter = ReflectionHelper.getInstanceFieldGetter(field);
            this.setter = ReflectionHelper.getInstanceFieldSetter(field);
        }

        public FIELDTYPE get(FIELDHOLDER instance) {
            return this.getter.apply(instance);
        }

        public void set(FIELDHOLDER instance, FIELDTYPE value) {
            this.setter.accept(instance, value);
        }
    }
}

