/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;
import mcjty.rftoolsdim.modules.knowledge.data.PatternBuilder;

public class RandomPatternCreator {
    private static final String[][] PATTERNS = new String[][]{{"      ", "      ", "  #   ", "      ", "      ", "      "}, {"      ", "      ", "   #  ", "      ", "      ", "      "}, {"      ", "      ", "      ", "  #   ", "      ", "      "}, {"      ", "      ", "      ", "   #  ", "      ", "      "}, {"      ", "  #   ", " ###  ", "  #   ", "      ", "      "}, {"      ", "      ", "  #   ", " ###  ", "  #   ", "      "}, {"      ", "   #  ", "  ### ", "   #  ", "      ", "      "}, {"      ", "      ", "   #  ", "  ### ", "   #  ", "      "}, {"      ", " # #  ", "  #   ", " # #  ", "      ", "      "}, {"       ", "  # #  ", "   #   ", "  # #  ", "       ", "       "}, {"      ", "      ", " # #  ", "  #   ", " # #  ", "      "}, {"       ", "       ", "  # #  ", "   #   ", "  # #  ", "       "}, {"  #   ", "  #   ", "##### ", "  #   ", "  #   ", "      "}, {"   #  ", "   #  ", " #####", "   #  ", "   #  ", "      "}, {"      ", "  #   ", "  #   ", "##### ", "  #   ", "  #   "}, {"      ", "   #  ", "   #  ", " #####", "   #  ", "   #  "}, {"      ", " #### ", "    # ", "    # ", " #### ", "      "}, {"      ", " #### ", " #    ", " #    ", " #### ", "      "}, {"      ", " #  # ", " #  # ", " #  # ", " #### ", "      "}, {"      ", " #### ", " #  # ", " #  # ", " #  # ", "      "}, {"#   # ", " # #  ", "  #   ", " # #  ", "#   # ", "      "}, {"#    #", " #  # ", "  ##  ", "  ##  ", " #  # ", "#    #"}, {"      ", " ###  ", " # #  ", " ###  ", "      ", "      "}, {"      ", "      ", " ###  ", " # #  ", " ###  ", "      "}, {"      ", "  ### ", "  # # ", "  ### ", "      ", "      "}, {"      ", "      ", "  ### ", "  # # ", "  ### ", "      "}, {"##### ", "#   # ", "#   # ", "#   # ", "##### ", "      "}, {" #####", " #   #", " #   #", " #   #", " #####", "      "}, {"      ", "##### ", "#   # ", "#   # ", "#   # ", "##### "}, {"      ", " #####", " #   #", " #   #", " #   #", " #####"}, {"##### ", "##### ", "## ## ", "##### ", "##### ", "      "}, {"# # # ", " # # #", "# # # ", " # # #", "# # # ", " # # #"}, {" # # #", "# # # ", " # # #", "# # # ", " # # #", "# # # "}, {"#   # ", "      ", "      ", "      ", "#   # ", "      "}, {"      ", " # #  ", "      ", " # #  ", "      ", "      "}, {"##  ##", "##  ##", "      ", "      ", "##  ##", "##  ##"}, {"#     ", " #    ", "  #   ", "   #  ", "    # ", "     #"}, {"     #", "    # ", "   #  ", "  #   ", " #    ", "#     "}, {"      ", " ##   ", " ##   ", "      ", "      ", "      "}, {"      ", "   ## ", "   ## ", "      ", "      ", "      "}, {"      ", "      ", "      ", " ##   ", " ##   ", "      "}, {"      ", "      ", "      ", "   ## ", "   ## ", "      "}, {"      ", " ###  ", " # #  ", " ###  ", "      ", "      "}, {"      ", "  ### ", "  # # ", "  ### ", "      ", "      "}, {"      ", "      ", " ###  ", " # #  ", " ###  ", "      "}, {"      ", "      ", "  ### ", "  # # ", "  ### ", "      "}, {"###   ", "###   ", "###   ", "      ", "      ", "      "}, {"   ###", "   ###", "   ###", "      ", "      ", "      "}, {"      ", "      ", "      ", "###   ", "###   ", "###   "}, {"      ", "      ", "      ", "   ###", "   ###", "   ###"}, {"      ", "   ## ", "  #   ", "   ## ", "      ", "      "}, {"      ", "  ##  ", "    # ", "  ##  ", "      ", "      "}, {"  #   ", " #    ", "#     ", " #    ", "  #   ", "      "}, {"   #  ", "  #   ", " #    ", "  #   ", "   #  ", "      "}, {"    # ", "   #  ", "  #   ", "   #  ", "    # ", "      "}, {"     #", "    # ", "   #  ", "    # ", "     #", "      "}, {"   #  ", "    # ", "     #", "    # ", "   #  ", "      "}, {"  #   ", "   #  ", "    # ", "   #  ", "  #   ", "      "}, {" #    ", "  #   ", "   #  ", "  #   ", " #    ", "      "}, {"#     ", " #    ", "  #   ", " #    ", "#     ", "      "}, {"  #   ", " # #  ", "#   # ", "      ", "      ", "      "}, {"      ", "  #   ", " # #  ", "#   # ", "      ", "      "}, {"      ", "      ", "  #   ", " # #  ", "#   # ", "      "}, {"      ", "      ", "      ", "  #   ", " # #  ", "#   # "}, {"      ", "      ", "      ", "#   # ", " # #  ", "  #   "}, {"      ", "      ", "#   # ", " # #  ", "  #   ", "      "}, {"      ", "#   # ", " # #  ", "  #   ", "      ", "      "}, {"#   # ", " # #  ", "  #   ", "      ", "      ", "      "}, {"  #   ", " # #  ", "#   # ", " # #  ", "  #   ", "      "}, {"   #  ", "  # # ", " #   #", "  # # ", "   #  ", "      "}, {"      ", "  #   ", " # #  ", "#   # ", " # #  ", "  #   "}, {"      ", "   #  ", "  # # ", " #   #", "  # # ", "   #  "}};

    private static SelectedPattern findUnusedPattern(Set<SelectedPattern> alreadyUsed, Supplier<SelectedPattern> generator) {
        SelectedPattern pattern = generator.get();
        while (alreadyUsed.contains(pattern)) {
            pattern = generator.get();
        }
        alreadyUsed.add(pattern);
        return pattern;
    }

    private static void applyPattern(PatternBuilder builder, String[] pattern, char c) {
        for (int y = 0; y < pattern.length; ++y) {
            for (int x = 0; x < pattern[y].length(); ++x) {
                char p = pattern[y].charAt(x);
                if (p != '#') continue;
                builder.set(x, y, c);
            }
        }
    }

    private static DimletPattern buildPattern(SelectedPattern selectedPattern) {
        int i4;
        int i3;
        PatternBuilder builder = new PatternBuilder();
        int i1 = selectedPattern.getI1();
        RandomPatternCreator.applyPattern(builder, PATTERNS[i1], '*');
        int i2 = selectedPattern.getI2();
        if (i2 != -1) {
            RandomPatternCreator.applyPattern(builder, PATTERNS[i2], '0');
        }
        if ((i3 = selectedPattern.getI3()) != -1) {
            RandomPatternCreator.applyPattern(builder, PATTERNS[i3], '1');
        }
        if ((i4 = selectedPattern.getI4()) != -1) {
            RandomPatternCreator.applyPattern(builder, PATTERNS[i4], '2');
        }
        return builder.build();
    }

    public static Map<KnowledgeKey, DimletPattern> createRandomPatterns(long seed) {
        HashSet<SelectedPattern> selectedPatterns = new HashSet<SelectedPattern>();
        HashMap<KnowledgeKey, SelectedPattern> patternMap = new HashMap<KnowledgeKey, SelectedPattern>();
        Random random = new Random(seed);
        random.nextInt();
        random.nextInt();
        for (KnowledgeSet set : KnowledgeSet.values()) {
            for (DimletType type : DimletType.values()) {
                SelectedPattern pattern0 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), -1, -1, -1));
                patternMap.put(new KnowledgeKey(type, DimletRarity.COMMON, set), pattern0);
                SelectedPattern pattern1 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), RandomPatternCreator.r(random), -1, -1));
                patternMap.put(new KnowledgeKey(type, DimletRarity.UNCOMMON, set), pattern1);
                SelectedPattern pattern2 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), RandomPatternCreator.r(random), RandomPatternCreator.r(random), -1));
                patternMap.put(new KnowledgeKey(type, DimletRarity.RARE, set), pattern2);
                SelectedPattern pattern3 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), RandomPatternCreator.r(random), RandomPatternCreator.r(random), RandomPatternCreator.r(random)));
                patternMap.put(new KnowledgeKey(type, DimletRarity.LEGENDARY, set), pattern3);
            }
        }
        HashMap<KnowledgeKey, DimletPattern> patterns = new HashMap<KnowledgeKey, DimletPattern>();
        for (Map.Entry entry : patternMap.entrySet()) {
            SelectedPattern selectedPattern = (SelectedPattern)entry.getValue();
            patterns.put((KnowledgeKey)entry.getKey(), RandomPatternCreator.buildPattern(selectedPattern));
        }
        return patterns;
    }

    private static int r(Random random) {
        return random.nextInt(PATTERNS.length);
    }

    private static class SelectedPattern {
        private final int i1;
        private final int i2;
        private final int i3;
        private final int i4;

        public SelectedPattern(int i1, int i2, int i3, int i4) {
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }

        public int getI1() {
            return this.i1;
        }

        public int getI2() {
            return this.i2;
        }

        public int getI3() {
            return this.i3;
        }

        public int getI4() {
            return this.i4;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectedPattern that = (SelectedPattern)o;
            return this.i1 == that.i1 && this.i2 == that.i2 && this.i3 == that.i3 && this.i4 == that.i4;
        }

        public int hashCode() {
            return Objects.hash(this.i1, this.i2, this.i3, this.i4);
        }
    }
}

