/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockAbsorberTileEntity
extends TickingTileEntity {
    private static final int ABSORB_SPEED = 2;
    private int absorbing = 0;
    private Block absorbingBlock = null;
    private int timer = 2;
    private final Set<BlockPos> toscan = new HashSet<BlockPos>();
    private final FakePlayerGetter harvester = new FakePlayerGetter((GenericTileEntity)this, "rftools_absorber");

    public BlockAbsorberTileEntity() {
        super((TileEntityType)EssencesModule.TYPE_BLOCK_ABSORBER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()).tileEntitySupplier(BlockAbsorberTileEntity::new).manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"block", BlockAbsorberTileEntity::getBlockName), TooltipBuilder.parameter((String)"progress", BlockAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getBlockName(ItemStack stack) {
        String block = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"block", null);
        if (block == null) {
            return "<Not Set>";
        }
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block));
        if (b != null) {
            return I18n.func_135052_a((String)b.func_149739_a(), (Object[])new Object[0]);
        }
        return "<Invalid>";
    }

    public static String getBlock(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"block", null);
    }

    private static String getProgressName(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxBlockAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBlockAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxBlockAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBlockAbsorption.get();
    }

    protected void tickServer() {
        if (this.absorbing > 0 || this.absorbingBlock == null) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 2;
                BlockState b = this.isValidSourceBlock(this.func_174877_v().func_177977_b());
                if (b != null) {
                    if (this.absorbingBlock == null) {
                        this.absorbing = (Integer)EssencesConfig.maxBlockAbsorption.get();
                        if (b.func_177230_c().func_199767_j() != Items.field_190931_a) {
                            this.absorbingBlock = b.func_177230_c();
                            this.toscan.clear();
                        }
                    }
                    this.toscan.add(this.func_174877_v().func_177977_b());
                }
                if (!this.toscan.isEmpty()) {
                    int r = this.field_145850_b.field_73012_v.nextInt(this.toscan.size());
                    Iterator<BlockPos> iterator = this.toscan.iterator();
                    BlockPos c = null;
                    for (int i = 0; i <= r; ++i) {
                        c = iterator.next();
                    }
                    this.toscan.remove(c);
                    this.checkBlock(c, Direction.DOWN);
                    this.checkBlock(c, Direction.UP);
                    this.checkBlock(c, Direction.EAST);
                    this.checkBlock(c, Direction.WEST);
                    this.checkBlock(c, Direction.SOUTH);
                    this.checkBlock(c, Direction.NORTH);
                    if (this.blockMatches(c)) {
                        BlockState oldState = this.field_145850_b.func_180495_p(c);
                        SoundTools.playSound((World)this.field_145850_b, (SoundEvent)this.absorbingBlock.getSoundType(oldState, (IWorldReader)this.field_145850_b, c, null).func_185845_c(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
                        this.field_145850_b.func_175656_a(c, Blocks.field_150350_a.func_176223_P());
                        --this.absorbing;
                        BlockState newState = this.field_145850_b.func_180495_p(c);
                        this.field_145850_b.func_184138_a(c, oldState, newState, 3);
                    }
                }
            }
            this.func_70296_d();
        }
    }

    protected void tickClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    private void checkBlock(BlockPos c, Direction direction) {
        BlockPos c2 = c.func_177972_a(direction);
        if (this.blockMatches(c2)) {
            this.toscan.add(c2);
        }
    }

    private boolean blockMatches(BlockPos c) {
        return this.field_145850_b.func_180495_p(c).func_177230_c().equals(this.absorbingBlock);
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public Block getAbsorbingBlock() {
        return this.absorbingBlock;
    }

    public static boolean allowedToBreak(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        float speed = state.func_185887_b((IBlockReader)world, pos);
        if (speed < 0.0f) {
            return false;
        }
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockReader)world, pos, (Entity)player)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private BlockState isValidSourceBlock(BlockPos coordinate) {
        BlockState state = this.field_145850_b.func_180495_p(coordinate);
        if (!BlockAbsorberTileEntity.allowedToBreak(state, this.field_145850_b, coordinate, (PlayerEntity)this.harvester.get())) {
            return null;
        }
        return this.isValidDimletBlock(state) ? state : null;
    }

    private boolean isValidDimletBlock(BlockState state) {
        Block block = state.func_177230_c();
        DimletKey key = new DimletKey(DimletType.BLOCK, block.getRegistryName().toString());
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        return settings != null && settings.isDimlet();
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        int[] x = tagCompound.func_74759_k("toscanx");
        int[] y = tagCompound.func_74759_k("toscany");
        int[] z = tagCompound.func_74759_k("toscanz");
        this.toscan.clear();
        for (int i = 0; i < x.length; ++i) {
            this.toscan.add(new BlockPos(x[i], y[i], z[i]));
        }
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            Block block;
            CompoundNBT info = tagCompound.func_74775_l("Info");
            this.absorbing = info.func_74762_e("absorbing");
            if (info.func_74764_b("block") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(info.func_74779_i("block")))) != null) {
                this.absorbingBlock = block;
            }
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        int[] x = new int[this.toscan.size()];
        int[] y = new int[this.toscan.size()];
        int[] z = new int[this.toscan.size()];
        int i = 0;
        for (BlockPos c : this.toscan) {
            x[i] = c.func_177958_n();
            y[i] = c.func_177956_o();
            z[i] = c.func_177952_p();
            ++i;
        }
        tagCompound.func_74783_a("toscanx", x);
        tagCompound.func_74783_a("toscany", y);
        tagCompound.func_74783_a("toscanz", z);
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("absorbing", this.absorbing);
        if (this.absorbingBlock != null) {
            info.func_74778_a("block", this.absorbingBlock.getRegistryName().toString());
        }
    }
}

