/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import java.util.Random;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class BiomeAbsorberTileEntity
extends TickingTileEntity {
    private int absorbing = 0;
    private String biomeId = null;

    public BiomeAbsorberTileEntity() {
        super((TileEntityType)EssencesModule.TYPE_BIOME_ABSORBER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()).tileEntitySupplier(BiomeAbsorberTileEntity::new).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"block", BiomeAbsorberTileEntity::getBiomeName), TooltipBuilder.parameter((String)"progress", BiomeAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getBiomeName(ItemStack stack) {
        String biome = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"biome", null);
        if (biome == null) {
            return "<Not Set>";
        }
        ResourceLocation id = new ResourceLocation(biome);
        String trans = "biome." + id.func_110624_b() + "." + id.func_110623_a();
        return I18n.func_135052_a((String)trans, (Object[])new Object[0]);
    }

    public static String getBiome(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74779_i, (String)"biome", null);
    }

    private static String getProgressName(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxBiomeAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxBiomeAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxBiomeAbsorption.get();
    }

    protected void tickClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public String getAbsorbingBiome() {
        return this.biomeId;
    }

    protected void tickServer() {
        Biome biome;
        if (this.biomeId == null) {
            biome = this.func_145831_w().func_226691_t_(this.func_174877_v());
            this.biomeId = biome.getRegistryName().toString();
            this.absorbing = (Integer)EssencesConfig.maxBiomeAbsorption.get();
            this.func_70296_d();
        }
        if (this.absorbing > 0) {
            biome = this.field_145850_b.func_226691_t_(this.field_174879_c);
            if (!biome.getRegistryName().toString().equals(this.biomeId)) {
                return;
            }
            --this.absorbing;
            this.func_70296_d();
        }
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("absorbing", this.absorbing);
        if (this.biomeId != null) {
            info.func_74778_a("biome", this.biomeId);
        }
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.absorbing = info.func_74762_e("absorbing");
        this.biomeId = info.func_74764_b("biome") ? info.func_74779_i("biome") : null;
    }
}

